/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

import org.unix4j.util.AbstractRange;
import org.unix4j.util.Assert;
import org.unix4j.util.CompositeRange;

public class Range {
    final CompositeRange compositeRange = new CompositeRange();

    private Range() {
    }

    private Range(AbstractRange range) {
        this.compositeRange.add(range);
    }

    public boolean isWithinRange(int index) {
        return this.compositeRange.isWithinRange(index);
    }

    public Range andOf(int ... indexes) {
        this.compositeRange.add(Range.of(indexes));
        return this;
    }

    public Range andFromStartTo(int to) {
        this.compositeRange.add(Range.fromStartTo(to));
        return this;
    }

    public Range andToEndFrom(int from) {
        this.compositeRange.add(Range.toEndFrom(from));
        return this;
    }

    public Range andBetween(int from, int to) {
        this.compositeRange.add(Range.between(from, to));
        return this;
    }

    public String toString() {
        return this.compositeRange.toString();
    }

    public static Range of(int ... indexes) {
        Range range = new Range();
        for (int i : indexes) {
            range.compositeRange.add(Range.includingSingleIndexOf(i));
        }
        return range;
    }

    public static Range fromStartTo(final int to) {
        Assert.assertArgGreaterThan("index must be greater than zero", to, 0);
        return new Range(new AbstractRange(){

            public String toString() {
                return "-" + to;
            }

            @Override
            public boolean isWithinRange(int index) {
                return index <= to;
            }
        });
    }

    public static Range toEndFrom(final int from) {
        Assert.assertArgGreaterThan("index must be greater than zero", from, 0);
        return new Range(new AbstractRange(){
            private final int index;
            {
                this.index = from;
            }

            public String toString() {
                return this.index + "-";
            }

            @Override
            public boolean isWithinRange(int index) {
                return index >= from;
            }
        });
    }

    public static Range between(final int from, final int to) {
        Assert.assertArgGreaterThan("index must be greater than zero", from, 0);
        return new Range(new AbstractRange(){

            public String toString() {
                return from + "-" + to;
            }

            @Override
            public boolean isWithinRange(int index) {
                return from <= index && index <= to;
            }
        });
    }

    private static AbstractRange includingSingleIndexOf(final int singleIndex) {
        Assert.assertArgGreaterThan("index must be greater than zero", singleIndex, 0);
        return new AbstractRange(){

            public String toString() {
                return "" + singleIndex;
            }

            @Override
            public boolean isWithinRange(int index) {
                return index == singleIndex;
            }
        };
    }
}

