/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

public class Assert {
    public static <T> T assertNotNull(String message, T value) {
        if (value != null) {
            return value;
        }
        throw new NullPointerException(message);
    }

    public static void assertArgNotNull(String message, Object obj) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
    }

    public static void assertArgNotNull(String message, Object ... objects) {
        for (Object obj : objects) {
            Assert.assertArgNotNull(message, obj);
        }
    }

    public static void assertArgTrue(String message, boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgGreaterThan(String message, int argValue, int num) {
        if (argValue <= num) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgGreaterThanOrEqualTo(String message, int argValue, int num) {
        if (argValue < num) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgLessThan(String message, int argValue, int num) {
        if (argValue >= num) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgLessThanOrEqualTo(String message, int argValue, int num) {
        if (argValue > num) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgFalse(String message, boolean expression) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

