/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.context;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.unix4j.context.DefaultExecutionContext;
import org.unix4j.context.ExecutionContext;
import org.unix4j.convert.ConverterRegistry;
import org.unix4j.convert.ValueConverter;
import org.unix4j.util.FileUtil;
import org.unix4j.variable.ExecutionContextVariableResolver;
import org.unix4j.variable.VariableContext;

public class DerivedExecutionContext
implements ExecutionContext {
    private final ExecutionContext delegate;
    private String user;
    private File userHome;
    private File tempDirectory;
    private File currentDirectory;
    private Locale locale;
    private Map<String, String> env = null;
    private Properties sys;
    private VariableContext variableContext = null;
    private ConverterRegistry converterRegistry = null;

    public DerivedExecutionContext() {
        this(new DefaultExecutionContext());
    }

    public DerivedExecutionContext(ExecutionContext delegate) {
        this.delegate = delegate;
        this.init();
    }

    protected void init() {
        this.getVariableContext().addVariableResolver(new ExecutionContextVariableResolver(this));
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.setCurrentDirectory(currentDirectory == null ? null : new File(currentDirectory));
    }

    @Override
    public File getCurrentDirectory() {
        if (this.currentDirectory != null) {
            return this.currentDirectory;
        }
        return this.delegate.getCurrentDirectory();
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public File getRelativeToCurrentDirectory(File file) {
        return FileUtil.toAbsoluteFile(this.getCurrentDirectory(), file);
    }

    @Override
    public String getUser() {
        if (this.user != null) {
            return this.user;
        }
        return this.delegate.getUser();
    }

    public void setUserHome(File userHome) {
        this.userHome = userHome;
    }

    public void setUserHome(String userHome) {
        this.setUserHome(userHome == null ? null : new File(userHome));
    }

    @Override
    public File getUserHome() {
        if (this.userHome != null) {
            return this.userHome;
        }
        return this.delegate.getUserHome();
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.setTempDirectory(tempDirectory == null ? null : new File(tempDirectory));
    }

    @Override
    public File getTempDirectory() {
        if (this.tempDirectory != null) {
            return this.tempDirectory;
        }
        return this.delegate.getTempDirectory();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return this.delegate.getLocale();
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    @Override
    public Map<String, String> getEnv() {
        if (this.env != null) {
            return this.env;
        }
        return this.delegate.getEnv();
    }

    public void setSys(Properties sys) {
        this.sys = sys;
    }

    @Override
    public Properties getSys() {
        if (this.sys != null) {
            return this.sys;
        }
        return this.delegate.getSys();
    }

    public void setVariableContext(VariableContext variableContext) {
        this.variableContext = variableContext;
    }

    @Override
    public VariableContext getVariableContext() {
        if (this.variableContext != null) {
            return this.variableContext;
        }
        return this.delegate.getVariableContext();
    }

    public void setConverterRegistry(ConverterRegistry converterRegistry) {
        this.converterRegistry = converterRegistry;
    }

    @Override
    public ConverterRegistry getConverterRegistry() {
        if (this.converterRegistry != null) {
            return this.converterRegistry;
        }
        return this.delegate.getConverterRegistry();
    }

    @Override
    public <V> ValueConverter<V> getValueConverterFor(Class<V> type) {
        return this.getConverterRegistry().getValueConverterFor(type);
    }
}

