/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.builder;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.unix4j.builder.CommandBuilder;
import org.unix4j.builder.DefaultCommandBuilder;
import org.unix4j.command.Command;
import org.unix4j.command.CommandInterface;

public class GenericCommandBuilder {
    public static <B extends CommandBuilder> B createCommandBuilder(Class<B> commandBuilderInterface, CommandInterface<? extends Command<?>> ... commandFactories) {
        return GenericCommandBuilder.createCommandBuilder(commandBuilderInterface, new DefaultCommandBuilder(), commandFactories);
    }

    public static <B extends CommandBuilder> B createCommandBuilder(Class<B> commandBuilderInterface, DefaultCommandBuilder defaultCommandBuilder, CommandInterface<? extends Command<?>> ... commandFactories) {
        if (commandBuilderInterface.isInterface()) {
            return (B)((CommandBuilder)Proxy.newProxyInstance(GenericCommandBuilder.class.getClassLoader(), new Class[]{commandBuilderInterface}, new GenericCommandHandler<B>(commandBuilderInterface, defaultCommandBuilder, commandFactories)));
        }
        throw new IllegalArgumentException(commandBuilderInterface.getName() + " must be an interface");
    }

    private static void addSignatures(Map<MethodSignature, Object> factoryMethods, Object factory) {
        for (Method method : factory.getClass().getMethods()) {
            MethodSignature signature = new MethodSignature(method);
            Object existingFactory = factoryMethods.get(signature);
            if (existingFactory == null) {
                factoryMethods.put(signature, factory);
                continue;
            }
            if (existingFactory == factory || DefaultCommandBuilder.class.isInstance(existingFactory)) continue;
            throw new IllegalArgumentException("method " + signature + " exist in " + existingFactory.getClass().getName() + " and also in " + factory.getClass().getName());
        }
    }

    private static class MethodSignature {
        private final String name;
        private final Class<?>[] parameterTypes;

        public MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public MethodSignature(String name, Class<?> ... parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public Method findInClass(Class<?> clazz) throws NoSuchMethodException {
            return clazz.getMethod(this.name, this.parameterTypes);
        }

        public Object invoke(Object instance, Object ... args) {
            try {
                Method method = this.findInClass(instance.getClass());
                return method.invoke(instance, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                throw new RuntimeException("invokation failed for method " + this + " in class " + instance.getClass().getName() + ", e=" + e, e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name).append('(');
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.parameterTypes[i].getName());
            }
            return sb.append(')').toString();
        }

        public int hashCode() {
            return 31 * this.name.hashCode() ^ Arrays.hashCode(this.parameterTypes);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof MethodSignature) {
                MethodSignature other = (MethodSignature)obj;
                if (!this.name.equals(other.name)) {
                    return false;
                }
                return Arrays.equals(this.parameterTypes, other.parameterTypes);
            }
            return false;
        }
    }

    private static class GenericCommandHandler<B extends CommandBuilder>
    implements InvocationHandler {
        private final DefaultCommandBuilder defaultCommandBuilder;
        private final Map<MethodSignature, Object> signatureToTarget = new HashMap<MethodSignature, Object>();

        public GenericCommandHandler(Class<B> commandBuilderInterface, DefaultCommandBuilder defaultCommandBuilder, CommandInterface<? extends Command<?>> ... commandFactories) {
            MethodSignature signature;
            this.defaultCommandBuilder = defaultCommandBuilder;
            HashMap factoryMethods = new HashMap();
            GenericCommandBuilder.addSignatures(factoryMethods, defaultCommandBuilder);
            for (int i = 0; i < commandFactories.length; ++i) {
                GenericCommandBuilder.addSignatures(factoryMethods, commandFactories[i]);
            }
            for (Method method : defaultCommandBuilder.getClass().getMethods()) {
                signature = new MethodSignature(method);
                this.signatureToTarget.put(signature, defaultCommandBuilder);
            }
            for (Method method : commandBuilderInterface.getMethods()) {
                signature = new MethodSignature(method);
                Object factory = factoryMethods.get(signature);
                if (factory == null) {
                    throw new IllegalArgumentException("No factory method found for method " + signature + " defined in interface " + commandBuilderInterface.getName());
                }
                Object otherFactory = this.signatureToTarget.get(signature);
                if (otherFactory == null) {
                    this.signatureToTarget.put(signature, factory);
                    continue;
                }
                if (factory == otherFactory) continue;
                throw new IllegalArgumentException("method " + signature + " exist in " + otherFactory.getClass().getName() + " and also in " + factory.getClass().getName());
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MethodSignature signature = new MethodSignature(method);
            Object target = this.signatureToTarget.get(signature);
            if (target != null) {
                Object result = signature.invoke(target, args);
                if (result instanceof Command) {
                    result = this.defaultCommandBuilder.join((Command)result);
                }
                if (result == this.defaultCommandBuilder) {
                    result = proxy;
                }
                return result;
            }
            throw new IllegalStateException("no target object found for method " + signature);
        }
    }
}

