/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.util;

import java.util.Map;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.web.IWebRequest;
import org.unbescape.uri.UriEscape;

public final class SpringRequestUtils {
    public static void checkViewNameNotInRequest(String viewName, IWebRequest request) {
        Map parameterMap;
        String vn = StringUtils.pack((String)viewName);
        if (!SpringRequestUtils.containsExpression(vn)) {
            return;
        }
        boolean found = false;
        String pathWithinApplication = StringUtils.pack((String)UriEscape.unescapeUriPath((String)request.getPathWithinApplication()));
        if (pathWithinApplication != null && SpringRequestUtils.containsExpression(pathWithinApplication)) {
            found = true;
        }
        if (!found && (parameterMap = request.getParameterMap()) != null && !parameterMap.isEmpty()) {
            for (String[] parameterValues : parameterMap.values()) {
                for (int i = 0; !found && i < parameterValues.length; ++i) {
                    String parameterValue = StringUtils.pack((String)parameterValues[i]);
                    if (parameterValue == null || !SpringRequestUtils.containsExpression(parameterValue) || !vn.contains(parameterValue)) continue;
                    found = true;
                }
                if (!found) continue;
                break;
            }
        }
        if (found) {
            throw new TemplateProcessingException("View name contains an expression and so does either the URL path or one of the request parameters. This is forbidden in order to reduce the possibilities that direct user input is executed as a part of the view name.");
        }
    }

    private static boolean containsExpression(String text) {
        int textLen = text.length();
        boolean expInit = false;
        for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (!expInit) {
                if (c != '$' && c != '*' && c != '#' && c != '@' && c != '~') continue;
                expInit = true;
                continue;
            }
            if (c == '{') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            expInit = false;
        }
        return false;
    }

    private SpringRequestUtils() {
    }
}

