/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import jakarta.servlet.ServletContext;
import jakarta.websocket.WebSocketContainer;
import jakarta.websocket.server.ServerContainer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;

public class ServletServerContainerFactoryBean
implements FactoryBean<WebSocketContainer>,
ServletContextAware,
InitializingBean {
    private @Nullable Long asyncSendTimeout;
    private @Nullable Long maxSessionIdleTimeout;
    private @Nullable Integer maxTextMessageBufferSize;
    private @Nullable Integer maxBinaryMessageBufferSize;
    private @Nullable ServletContext servletContext;
    private @Nullable ServerContainer serverContainer;

    public void setAsyncSendTimeout(@Nullable Long timeoutInMillis) {
        this.asyncSendTimeout = timeoutInMillis;
    }

    public @Nullable Long getAsyncSendTimeout() {
        return this.asyncSendTimeout;
    }

    public void setMaxSessionIdleTimeout(@Nullable Long timeoutInMillis) {
        this.maxSessionIdleTimeout = timeoutInMillis;
    }

    public @Nullable Long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setMaxTextMessageBufferSize(@Nullable Integer bufferSize) {
        this.maxTextMessageBufferSize = bufferSize;
    }

    public @Nullable Integer getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(@Nullable Integer bufferSize) {
        this.maxBinaryMessageBufferSize = bufferSize;
    }

    public @Nullable Integer getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setServletContext(@Nullable ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() {
        Assert.state((this.servletContext != null ? 1 : 0) != 0, (String)"A ServletContext is required to access the jakarta.websocket.server.ServerContainer instance");
        this.serverContainer = (ServerContainer)this.servletContext.getAttribute("jakarta.websocket.server.ServerContainer");
        Assert.state((this.serverContainer != null ? 1 : 0) != 0, (String)"Attribute 'jakarta.websocket.server.ServerContainer' not found in ServletContext");
        if (this.asyncSendTimeout != null) {
            this.serverContainer.setAsyncSendTimeout(this.asyncSendTimeout.longValue());
        }
        if (this.maxSessionIdleTimeout != null) {
            this.serverContainer.setDefaultMaxSessionIdleTimeout(this.maxSessionIdleTimeout.longValue());
        }
        if (this.maxTextMessageBufferSize != null) {
            this.serverContainer.setDefaultMaxTextMessageBufferSize(this.maxTextMessageBufferSize.intValue());
        }
        if (this.maxBinaryMessageBufferSize != null) {
            this.serverContainer.setDefaultMaxBinaryMessageBufferSize(this.maxBinaryMessageBufferSize.intValue());
        }
    }

    public @Nullable ServerContainer getObject() {
        return this.serverContainer;
    }

    public Class<?> getObjectType() {
        return this.serverContainer != null ? this.serverContainer.getClass() : ServerContainer.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

