/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server.assertj;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ByteArrayAssert;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.test.http.HttpHeadersAssert;
import org.springframework.test.http.MediaTypeAssert;
import org.springframework.test.json.AbstractJsonContentAssert;
import org.springframework.test.json.JsonContent;
import org.springframework.test.json.JsonContentAssert;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.assertj.ResponseCookieMapAssert;
import org.springframework.test.web.reactive.server.assertj.WebTestClientResponse;
import org.springframework.util.function.SingletonSupplier;

public class WebTestClientResponseAssert
extends AbstractObjectAssert<WebTestClientResponseAssert, WebTestClientResponse> {
    private final Supplier<MediaTypeAssert> contentTypeAssertSupplier = SingletonSupplier.of(() -> new MediaTypeAssert(this.getExchangeResult().getResponseHeaders().getContentType()));
    private final Supplier<HttpHeadersAssert> headersAssertSupplier = SingletonSupplier.of(() -> new HttpHeadersAssert(this.getExchangeResult().getResponseHeaders()));
    private final Supplier<AbstractIntegerAssert<?>> statusAssert = SingletonSupplier.of(() -> (AbstractIntegerAssert)Assertions.assertThat((int)this.getExchangeResult().getStatus().value()).as("HTTP status code", new Object[0]));

    WebTestClientResponseAssert(WebTestClientResponse actual) {
        super((Object)actual, WebTestClientResponseAssert.class);
    }

    public WebTestClientResponseAssert hasStatus(int status) {
        this.status().isEqualTo(status);
        return (WebTestClientResponseAssert)this.myself;
    }

    public WebTestClientResponseAssert hasStatus(HttpStatus status) {
        return this.hasStatus(status.value());
    }

    public WebTestClientResponseAssert hasStatusOk() {
        return this.hasStatus(HttpStatus.OK);
    }

    public WebTestClientResponseAssert hasStatus1xxInformational() {
        return this.hasStatusSeries(HttpStatus.Series.INFORMATIONAL);
    }

    public WebTestClientResponseAssert hasStatus2xxSuccessful() {
        return this.hasStatusSeries(HttpStatus.Series.SUCCESSFUL);
    }

    public WebTestClientResponseAssert hasStatus3xxRedirection() {
        return this.hasStatusSeries(HttpStatus.Series.REDIRECTION);
    }

    public WebTestClientResponseAssert hasStatus4xxClientError() {
        return this.hasStatusSeries(HttpStatus.Series.CLIENT_ERROR);
    }

    public WebTestClientResponseAssert hasStatus5xxServerError() {
        return this.hasStatusSeries(HttpStatus.Series.SERVER_ERROR);
    }

    private WebTestClientResponseAssert hasStatusSeries(HttpStatus.Series series) {
        HttpStatusCode status = this.getExchangeResult().getStatus();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)HttpStatus.Series.resolve((int)status.value())).as("HTTP status series", new Object[0])).isEqualTo((Object)series);
        return (WebTestClientResponseAssert)this.myself;
    }

    private AbstractIntegerAssert<?> status() {
        return this.statusAssert.get();
    }

    public HttpHeadersAssert headers() {
        return this.headersAssertSupplier.get();
    }

    public WebTestClientResponseAssert containsHeader(String name) {
        this.headers().containsHeader(name);
        return (WebTestClientResponseAssert)this.myself;
    }

    public WebTestClientResponseAssert doesNotContainHeader(String name) {
        this.headers().doesNotContainHeader(name);
        return (WebTestClientResponseAssert)this.myself;
    }

    public WebTestClientResponseAssert hasHeader(String name, String value) {
        this.headers().hasValue(name, value);
        return (WebTestClientResponseAssert)this.myself;
    }

    public MediaTypeAssert contentType() {
        return this.contentTypeAssertSupplier.get();
    }

    public WebTestClientResponseAssert hasContentType(MediaType contentType) {
        this.contentType().isEqualTo(contentType);
        return (WebTestClientResponseAssert)this.myself;
    }

    public WebTestClientResponseAssert hasContentType(String contentType) {
        this.contentType().isEqualTo(contentType);
        return (WebTestClientResponseAssert)this.myself;
    }

    public WebTestClientResponseAssert hasContentTypeCompatibleWith(MediaType contentType) {
        this.contentType().isCompatibleWith(contentType);
        return (WebTestClientResponseAssert)this.myself;
    }

    public WebTestClientResponseAssert hasContentTypeCompatibleWith(String contentType) {
        this.contentType().isCompatibleWith(contentType);
        return (WebTestClientResponseAssert)this.myself;
    }

    public ResponseCookieMapAssert cookies() {
        return new ResponseCookieMapAssert(this.getCookies());
    }

    private ResponseCookie[] getCookies() {
        return (ResponseCookie[])this.getExchangeResult().getResponseCookies().values().stream().flatMap(Collection::stream).toArray(ResponseCookie[]::new);
    }

    public AbstractByteArrayAssert<?> body() {
        return new ByteArrayAssert(this.getExchangeResult().getResponseBodyContent());
    }

    public AbstractStringAssert<?> bodyText() {
        return Assertions.assertThat((String)this.readBody());
    }

    public WebTestClientResponseAssert hasBodyTextEqualTo(String bodyText) {
        this.bodyText().isEqualTo(bodyText);
        return (WebTestClientResponseAssert)this.myself;
    }

    public AbstractJsonContentAssert<?> bodyJson() {
        return new JsonContentAssert(new JsonContent(this.readBody(), this.getExchangeResult().getJsonConverterDelegate()));
    }

    private String readBody() {
        return new String(this.getExchangeResult().getResponseBodyContent(), this.getCharset());
    }

    private Charset getCharset() {
        ExchangeResult result = this.getExchangeResult();
        MediaType contentType = result.getResponseHeaders().getContentType();
        Charset charset = contentType != null ? contentType.getCharset() : null;
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    private ExchangeResult getExchangeResult() {
        return ((WebTestClientResponse)this.actual).getExchangeResult();
    }
}

