/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.hibernate;

import org.hibernate.Session;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jpa.hibernate.HibernateExceptionTranslator;
import org.springframework.transaction.support.TransactionSynchronization;

class SpringFlushSynchronization
implements TransactionSynchronization {
    static final HibernateExceptionTranslator exceptionTranslator = new HibernateExceptionTranslator();
    private final Session session;

    public SpringFlushSynchronization(Session session) {
        this.session = session;
    }

    public void flush() {
        try {
            this.session.flush();
        }
        catch (RuntimeException ex) {
            throw DataAccessUtils.translateIfNecessary((RuntimeException)ex, (PersistenceExceptionTranslator)exceptionTranslator);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof SpringFlushSynchronization)) return false;
        SpringFlushSynchronization that = (SpringFlushSynchronization)other;
        if (this.session != that.session) return false;
        return true;
    }

    public int hashCode() {
        return this.session.hashCode();
    }
}

