/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class FormPostRedirectStrategy
implements RedirectStrategy {
    private static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    private static final String REDIRECT_PAGE_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n    <title>Redirect</title>\n  </head>\n  <body>\n    <form id=\"redirect-form\" method=\"POST\" action=\"{{action}}\">\n      {{params}}\n      <noscript>\n        <p>JavaScript is not enabled for this page.</p>\n        <button type=\"submit\">Click to continue</button>\n      </noscript>\n    </form>\n    <script nonce=\"{{nonce}}\">\n      document.getElementById(\"redirect-form\").submit();\n    </script>\n  </body>\n</html>\n";
    private static final String HIDDEN_INPUT_TEMPLATE = "<input name=\"{{name}}\" type=\"hidden\" value=\"{{value}}\" />\n";
    private static final StringKeyGenerator DEFAULT_NONCE_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);

    @Override
    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url);
        StringBuilder hiddenInputsHtmlBuilder = new StringBuilder();
        for (Map.Entry entry : uriComponentsBuilder.build().getQueryParams().entrySet()) {
            String name = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                String hiddenInput = HIDDEN_INPUT_TEMPLATE.replace("{{name}}", HtmlUtils.htmlEscape((String)name)).replace("{{value}}", HtmlUtils.htmlEscape((String)value));
                hiddenInputsHtmlBuilder.append(hiddenInput.trim());
            }
        }
        String nonce = DEFAULT_NONCE_GENERATOR.generateKey();
        String policyDirective = "script-src 'nonce-%s'".formatted(nonce);
        String html = REDIRECT_PAGE_TEMPLATE.replace("{{action}}", HtmlUtils.htmlEscape((String)uriComponentsBuilder.replaceQuery(null).build().toUriString())).replace("{{params}}", hiddenInputsHtmlBuilder.toString()).replace("{{nonce}}", HtmlUtils.htmlEscape((String)nonce));
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("text/html");
        response.setHeader(CONTENT_SECURITY_POLICY_HEADER, policyDirective);
        response.getWriter().write(html);
        response.getWriter().flush();
    }
}

