/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ui;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.ui.HtmlTemplates;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class DefaultLoginPageGeneratingFilter
extends GenericFilterBean {
    public static final String DEFAULT_LOGIN_PAGE_URL = "/login";
    public static final String ERROR_PARAMETER_NAME = "error";
    private String loginPageUrl;
    private String logoutSuccessUrl;
    private String failureUrl;
    private boolean formLoginEnabled;
    private boolean oauth2LoginEnabled;
    private boolean saml2LoginEnabled;
    private boolean passkeysEnabled;
    private boolean oneTimeTokenEnabled;
    private String authenticationUrl;
    private String generateOneTimeTokenUrl;
    private String usernameParameter;
    private String passwordParameter;
    private String rememberMeParameter;
    private Map<String, String> oauth2AuthenticationUrlToClientName;
    private Map<String, String> saml2AuthenticationUrlToProviderName;
    private Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs = request -> Collections.emptyMap();
    private Function<HttpServletRequest, Map<String, String>> resolveHeaders = request -> Collections.emptyMap();
    private static final String CSRF_HEADERS = "{\"{{headerName}}\" : \"{{headerValue}}\"}";
    private static final String PASSKEY_SCRIPT_TEMPLATE = "\t<script type=\"text/javascript\" src=\"{{contextPath}}/login/webauthn.js\"></script>\n\t<script type=\"text/javascript\">\n\t<!--\n\t\tdocument.addEventListener(\"DOMContentLoaded\",() => setupLogin({{csrfHeaders}}, \"{{contextPath}}\", document.getElementById('passkey-signin')));\n\n\t//-->\n\t</script>\n";
    private static final String PASSKEY_FORM_TEMPLATE = "<div class=\"login-form\">\n<h2>Login with Passkeys</h2>\n<button id=\"passkey-signin\" type=\"submit\" class=\"primary\">Sign in with a passkey</button>\n</form>\n";
    private static final String LOGIN_PAGE_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n    <title>Please sign in</title>\n    <link href=\"{{contextPath}}/default-ui.css\" rel=\"stylesheet\" />{{javaScript}}\n  </head>\n  <body>\n    <div class=\"content\">\n{{formLogin}}\n{{oneTimeTokenLogin}}{{passkeyLogin}}\n{{oauth2Login}}\n{{saml2Login}}\n    </div>\n  </body>\n</html>";
    private static final String LOGIN_FORM_TEMPLATE = "      <form class=\"login-form\" method=\"post\" action=\"{{loginUrl}}\">\n        <h2>Please sign in</h2>\n{{errorMessage}}{{logoutMessage}}\n        <p>\n          <label for=\"username\" class=\"screenreader\">Username</label>\n          <input type=\"text\" id=\"username\" name=\"{{usernameParameter}}\" placeholder=\"Username\" required autofocus>\n        </p>\n        <p>\n          <label for=\"password\" class=\"screenreader\">Password</label>\n          <input type=\"password\" id=\"password\" name=\"{{passwordParameter}}\" placeholder=\"Password\" {{autocomplete}}required>\n        </p>\n{{rememberMeInput}}\n{{hiddenInputs}}\n        <button type=\"submit\" class=\"primary\">Sign in</button>\n      </form>";
    private static final String HIDDEN_HTML_INPUT_TEMPLATE = "<input name=\"{{name}}\" type=\"hidden\" value=\"{{value}}\" />\n";
    private static final String ALERT_TEMPLATE = "<div class=\"alert alert-danger\" role=\"alert\">{{message}}</div>";
    private static final String OAUTH2_LOGIN_TEMPLATE = "<h2>Login with OAuth 2.0</h2>\n{{errorMessage}}{{logoutMessage}}\n<table class=\"table table-striped\">\n  {{oauth2Rows}}\n</table>";
    private static final String OAUTH2_ROW_TEMPLATE = "<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>";
    private static final String SAML_LOGIN_TEMPLATE = "<h2>Login with SAML 2.0</h2>\n{{errorMessage}}{{logoutMessage}}\n<table class=\"table table-striped\">\n  {{samlRows}}\n</table>";
    private static final String SAML_ROW_TEMPLATE = "<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>";
    private static final String ONE_TIME_TEMPLATE = "      <form id=\"ott-form\" class=\"login-form\" method=\"post\" action=\"{{generateOneTimeTokenUrl}}\">\n        <h2>Request a One-Time Token</h2>\n{{errorMessage}}{{logoutMessage}}\n        <p>\n          <label for=\"ott-username\" class=\"screenreader\">Username</label>\n          <input type=\"text\" id=\"ott-username\" name=\"username\" placeholder=\"Username\" required>\n        </p>\n{{hiddenInputs}}\n        <button class=\"primary\" type=\"submit\" form=\"ott-form\">Send Token</button>\n      </form>\n";

    public DefaultLoginPageGeneratingFilter() {
    }

    public DefaultLoginPageGeneratingFilter(UsernamePasswordAuthenticationFilter authFilter) {
        this.loginPageUrl = DEFAULT_LOGIN_PAGE_URL;
        this.logoutSuccessUrl = "/login?logout";
        this.failureUrl = "/login?error";
        if (authFilter != null) {
            this.initAuthFilter(authFilter);
        }
    }

    private void initAuthFilter(UsernamePasswordAuthenticationFilter authFilter) {
        this.formLoginEnabled = true;
        this.usernameParameter = authFilter.getUsernameParameter();
        this.passwordParameter = authFilter.getPasswordParameter();
        RememberMeServices rememberMeServices = authFilter.getRememberMeServices();
        if (rememberMeServices instanceof AbstractRememberMeServices) {
            AbstractRememberMeServices rememberMeServices2 = (AbstractRememberMeServices)rememberMeServices;
            this.rememberMeParameter = rememberMeServices2.getParameter();
        }
    }

    public void setResolveHiddenInputs(Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs) {
        Assert.notNull(resolveHiddenInputs, (String)"resolveHiddenInputs cannot be null");
        this.resolveHiddenInputs = resolveHiddenInputs;
    }

    public void setResolveHeaders(Function<HttpServletRequest, Map<String, String>> resolveHeaders) {
        Assert.notNull(resolveHeaders, (String)"resolveHeaders cannot be null");
        this.resolveHeaders = resolveHeaders;
    }

    public boolean isEnabled() {
        return this.formLoginEnabled || this.oauth2LoginEnabled || this.saml2LoginEnabled;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public String getLoginPageUrl() {
        return this.loginPageUrl;
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public void setFormLoginEnabled(boolean formLoginEnabled) {
        this.formLoginEnabled = formLoginEnabled;
    }

    public void setOauth2LoginEnabled(boolean oauth2LoginEnabled) {
        this.oauth2LoginEnabled = oauth2LoginEnabled;
    }

    public void setOneTimeTokenEnabled(boolean oneTimeTokenEnabled) {
        this.oneTimeTokenEnabled = oneTimeTokenEnabled;
    }

    public void setSaml2LoginEnabled(boolean saml2LoginEnabled) {
        this.saml2LoginEnabled = saml2LoginEnabled;
    }

    public void setPasskeysEnabled(boolean passkeysEnabled) {
        this.passkeysEnabled = passkeysEnabled;
    }

    public void setAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
    }

    public void setOneTimeTokenGenerationUrl(String generateOneTimeTokenUrl) {
        this.generateOneTimeTokenUrl = generateOneTimeTokenUrl;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setRememberMeParameter(String rememberMeParameter) {
        this.rememberMeParameter = rememberMeParameter;
    }

    public void setOauth2AuthenticationUrlToClientName(Map<String, String> oauth2AuthenticationUrlToClientName) {
        this.oauth2AuthenticationUrlToClientName = oauth2AuthenticationUrlToClientName;
    }

    public void setSaml2AuthenticationUrlToProviderName(Map<String, String> saml2AuthenticationUrlToProviderName) {
        this.saml2AuthenticationUrlToProviderName = saml2AuthenticationUrlToProviderName;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean loginError = this.isErrorPage(request);
        boolean logoutSuccess = this.isLogoutSuccess(request);
        if (this.isLoginUrlRequest(request) || loginError || logoutSuccess) {
            String loginPageHtml = this.generateLoginPageHtml(request, loginError, logoutSuccess);
            response.setContentType("text/html;charset=UTF-8");
            response.setContentLength(loginPageHtml.getBytes(StandardCharsets.UTF_8).length);
            response.getWriter().write(loginPageHtml);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String generateLoginPageHtml(HttpServletRequest request, boolean loginError, boolean logoutSuccess) {
        String errorMsg = loginError ? this.getLoginErrorMessage(request) : "Invalid credentials";
        String contextPath = request.getContextPath();
        return HtmlTemplates.fromTemplate(LOGIN_PAGE_TEMPLATE).withRawHtml("contextPath", contextPath).withRawHtml("javaScript", this.renderJavaScript(request, contextPath)).withRawHtml("formLogin", this.renderFormLogin(request, loginError, logoutSuccess, contextPath, errorMsg)).withRawHtml("oneTimeTokenLogin", this.renderOneTimeTokenLogin(request, loginError, logoutSuccess, contextPath, errorMsg)).withRawHtml("oauth2Login", this.renderOAuth2Login(loginError, logoutSuccess, errorMsg, contextPath)).withRawHtml("saml2Login", this.renderSaml2Login(loginError, logoutSuccess, errorMsg, contextPath)).withRawHtml("passkeyLogin", this.renderPasskeyLogin()).render();
    }

    private String renderJavaScript(HttpServletRequest request, String contextPath) {
        if (this.passkeysEnabled) {
            return HtmlTemplates.fromTemplate(PASSKEY_SCRIPT_TEMPLATE).withValue("loginPageUrl", this.loginPageUrl).withValue("contextPath", contextPath).withRawHtml("csrfHeaders", this.renderHeaders(request)).render();
        }
        return "";
    }

    private String renderPasskeyLogin() {
        if (this.passkeysEnabled) {
            return PASSKEY_FORM_TEMPLATE;
        }
        return "";
    }

    private String renderHeaders(HttpServletRequest request) {
        StringBuffer javascriptHeadersEntries = new StringBuffer();
        Map<String, String> headers = this.resolveHeaders.apply(request);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            javascriptHeadersEntries.append(HtmlTemplates.fromTemplate(CSRF_HEADERS).withValue("headerName", header.getKey()).withValue("headerValue", header.getValue()).render());
        }
        return javascriptHeadersEntries.toString();
    }

    private String renderFormLogin(HttpServletRequest request, boolean loginError, boolean logoutSuccess, String contextPath, String errorMsg) {
        if (!this.formLoginEnabled) {
            return "";
        }
        String hiddenInputs = this.resolveHiddenInputs.apply(request).entrySet().stream().map(inputKeyValue -> this.renderHiddenInput((String)inputKeyValue.getKey(), (String)inputKeyValue.getValue())).collect(Collectors.joining("\n"));
        return HtmlTemplates.fromTemplate(LOGIN_FORM_TEMPLATE).withValue("loginUrl", contextPath + this.authenticationUrl).withRawHtml("errorMessage", this.renderError(loginError, errorMsg)).withRawHtml("logoutMessage", this.renderSuccess(logoutSuccess)).withValue("usernameParameter", this.usernameParameter).withValue("passwordParameter", this.passwordParameter).withRawHtml("rememberMeInput", this.renderRememberMe(this.rememberMeParameter)).withRawHtml("hiddenInputs", hiddenInputs).withValue("autocomplete", this.passkeysEnabled ? "autocomplete=\"password webauthn\"" : "").render();
    }

    private String renderOneTimeTokenLogin(HttpServletRequest request, boolean loginError, boolean logoutSuccess, String contextPath, String errorMsg) {
        if (!this.oneTimeTokenEnabled) {
            return "";
        }
        String hiddenInputs = this.resolveHiddenInputs.apply(request).entrySet().stream().map(inputKeyValue -> this.renderHiddenInput((String)inputKeyValue.getKey(), (String)inputKeyValue.getValue())).collect(Collectors.joining("\n"));
        return HtmlTemplates.fromTemplate(ONE_TIME_TEMPLATE).withValue("generateOneTimeTokenUrl", contextPath + this.generateOneTimeTokenUrl).withRawHtml("errorMessage", this.renderError(loginError, errorMsg)).withRawHtml("logoutMessage", this.renderSuccess(logoutSuccess)).withRawHtml("hiddenInputs", hiddenInputs).render();
    }

    private String renderOAuth2Login(boolean loginError, boolean logoutSuccess, String errorMsg, String contextPath) {
        if (!this.oauth2LoginEnabled) {
            return "";
        }
        String oauth2Rows = this.oauth2AuthenticationUrlToClientName.entrySet().stream().map(urlToName -> DefaultLoginPageGeneratingFilter.renderOAuth2Row(contextPath, (String)urlToName.getKey(), (String)urlToName.getValue())).collect(Collectors.joining("\n"));
        return HtmlTemplates.fromTemplate(OAUTH2_LOGIN_TEMPLATE).withRawHtml("errorMessage", this.renderError(loginError, errorMsg)).withRawHtml("logoutMessage", this.renderSuccess(logoutSuccess)).withRawHtml("oauth2Rows", oauth2Rows).render();
    }

    private static String renderOAuth2Row(String contextPath, String url, String clientName) {
        return HtmlTemplates.fromTemplate("<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>").withValue("url", contextPath + url).withValue("clientName", clientName).render();
    }

    private String renderSaml2Login(boolean loginError, boolean logoutSuccess, String errorMsg, String contextPath) {
        if (!this.saml2LoginEnabled) {
            return "";
        }
        String samlRows = this.saml2AuthenticationUrlToProviderName.entrySet().stream().map(urlToName -> DefaultLoginPageGeneratingFilter.renderSaml2Row(contextPath, (String)urlToName.getKey(), (String)urlToName.getValue())).collect(Collectors.joining("\n"));
        return HtmlTemplates.fromTemplate(SAML_LOGIN_TEMPLATE).withRawHtml("errorMessage", this.renderError(loginError, errorMsg)).withRawHtml("logoutMessage", this.renderSuccess(logoutSuccess)).withRawHtml("samlRows", samlRows).render();
    }

    private static String renderSaml2Row(String contextPath, String url, String clientName) {
        return HtmlTemplates.fromTemplate("<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>").withValue("url", contextPath + url).withValue("clientName", clientName).render();
    }

    private String getLoginErrorMessage(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return "Invalid credentials";
        }
        Object object = session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (!(object instanceof AuthenticationException)) {
            return "Invalid credentials";
        }
        AuthenticationException exception = (AuthenticationException)((Object)object);
        if (!StringUtils.hasText((String)exception.getMessage())) {
            return "Invalid credentials";
        }
        return exception.getMessage();
    }

    private String renderHiddenInput(String name, String value) {
        return HtmlTemplates.fromTemplate(HIDDEN_HTML_INPUT_TEMPLATE).withValue("name", name).withValue("value", value).render();
    }

    private String renderRememberMe(String paramName) {
        if (paramName == null) {
            return "";
        }
        return HtmlTemplates.fromTemplate("<p><input type='checkbox' name='{{paramName}}'/> Remember me on this computer.</p>").withValue("paramName", paramName).render();
    }

    private boolean isLogoutSuccess(HttpServletRequest request) {
        return this.logoutSuccessUrl != null && this.matches(request, this.logoutSuccessUrl);
    }

    private boolean isLoginUrlRequest(HttpServletRequest request) {
        return this.matches(request, this.loginPageUrl);
    }

    private boolean isErrorPage(HttpServletRequest request) {
        return this.matches(request, this.failureUrl);
    }

    private String renderError(boolean isError, String message) {
        if (!isError) {
            return "";
        }
        return HtmlTemplates.fromTemplate(ALERT_TEMPLATE).withValue("message", message).render();
    }

    private String renderSuccess(boolean isLogoutSuccess) {
        if (!isLogoutSuccess) {
            return "";
        }
        return "<div class=\"alert alert-success\" role=\"alert\">You have been signed out</div>";
    }

    private boolean matches(HttpServletRequest request, String url) {
        if (!"GET".equals(request.getMethod()) || url == null) {
            return false;
        }
        Object uri = request.getRequestURI();
        int pathParamIndex = ((String)uri).indexOf(59);
        if (pathParamIndex > 0) {
            uri = ((String)uri).substring(0, pathParamIndex);
        }
        if (request.getQueryString() != null) {
            uri = (String)uri + "?" + request.getQueryString();
        }
        if ("".equals(request.getContextPath())) {
            return ((String)uri).equals(url);
        }
        return ((String)uri).equals(request.getContextPath() + url);
    }
}

