/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.client;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.HttpRequest;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.web.client.OAuth2ClientHttpRequestInterceptor;
import org.springframework.util.Assert;

public class RequestAttributePrincipalResolver
implements OAuth2ClientHttpRequestInterceptor.PrincipalResolver {
    private static final String PRINCIPAL_ATTR_NAME = RequestAttributePrincipalResolver.class.getName().concat(".principal");

    @Override
    public Authentication resolve(HttpRequest request) {
        return (Authentication)request.getAttributes().get(PRINCIPAL_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> principal(Authentication principal) {
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        return attributes -> attributes.put(PRINCIPAL_ATTR_NAME, principal);
    }

    public static Consumer<Map<String, Object>> principal(String principalName) {
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        Authentication principal = RequestAttributePrincipalResolver.createAuthentication(principalName);
        return attributes -> attributes.put(PRINCIPAL_ATTR_NAME, principal);
    }

    private static Authentication createAuthentication(final String principalName) {
        return new AbstractAuthenticationToken(Collections.emptySet()){

            public Object getPrincipal() {
                return principalName;
            }

            public Object getCredentials() {
                return null;
            }
        };
    }
}

