/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.Jsr250AuthorizationManager;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class Jsr250MethodSecurityConfiguration {
    private final Jsr250AuthorizationManager jsr250AuthorizationManager = new Jsr250AuthorizationManager();
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    Jsr250MethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    MethodInterceptor jsr250AuthorizationMethodInterceptor() {
        AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.jsr250((Jsr250AuthorizationManager)this.jsr250AuthorizationManager);
        interceptor.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
        return interceptor;
    }

    @Autowired(required=false)
    void setGrantedAuthorityDefaults(GrantedAuthorityDefaults grantedAuthorityDefaults) {
        this.jsr250AuthorizationManager.setRolePrefix(grantedAuthorityDefaults.getRolePrefix());
    }

    @Autowired(required=false)
    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }
}

