/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.springframework.core.ResolvableType;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.JsonProjectingMethodInterceptorFactory;
import org.springframework.kafka.support.JacksonUtils;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.kafka.support.converter.StringJsonMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ProjectingMessageConverter
extends MessagingMessageConverter {
    private final ProjectionFactory projectionFactory;
    private final MessagingMessageConverter delegate;

    public ProjectingMessageConverter() {
        this(JacksonUtils.enhancedObjectMapper());
    }

    public ProjectingMessageConverter(ObjectMapper mapper) {
        this(mapper, new StringJsonMessageConverter());
    }

    public ProjectingMessageConverter(MessagingMessageConverter delegate) {
        this(JacksonUtils.enhancedObjectMapper(), delegate);
    }

    public ProjectingMessageConverter(ObjectMapper mapper, MessagingMessageConverter delegate) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)delegate, (String)"'delegate' cannot be null");
        JacksonMappingProvider provider = new JacksonMappingProvider(mapper);
        JsonProjectingMethodInterceptorFactory interceptorFactory = new JsonProjectingMethodInterceptorFactory((MappingProvider)provider);
        SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory();
        factory.registerMethodInvokerFactory((MethodInterceptorFactory)interceptorFactory);
        this.projectionFactory = factory;
        this.delegate = delegate;
    }

    @Override
    protected Object convertPayload(Message<?> message) {
        return this.delegate.convertPayload(message);
    }

    @Override
    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        Object value = record.value();
        if (value == null) {
            return KafkaNull.INSTANCE;
        }
        Class rawType = ResolvableType.forType((Type)type).resolve(Object.class);
        if (!rawType.isInterface()) {
            return this.delegate.extractAndConvertValue(record, type);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(ProjectingMessageConverter.getAsByteArray(value));
        return this.projectionFactory.createProjection(rawType, (Object)inputStream);
    }

    private static byte[] getAsByteArray(Object source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        if (source instanceof String) {
            return ((String)source).getBytes(StandardCharsets.UTF_8);
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (source instanceof Bytes) {
            return ((Bytes)source).get();
        }
        throw new ConversionException(String.format("Unsupported payload type '%s'. Expected 'String', 'Bytes', or 'byte[]'", source.getClass()), null);
    }
}

