/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.reactive.BaseRedisReactiveCommands;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import io.lettuce.core.codec.RedisCodec;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveNumberCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveScriptingCommands;
import org.springframework.data.redis.connection.ReactiveServerCommands;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveHashCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveNumberCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveScriptingCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveServerCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveZSetCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveRedisConnection
implements ReactiveRedisConnection {
    static final RedisCodec<ByteBuffer, ByteBuffer> CODEC = ByteBufferCodec.INSTANCE;
    private final LettuceConnectionProvider connectionProvider;
    private StatefulConnection<ByteBuffer, ByteBuffer> connection;

    LettuceReactiveRedisConnection(LettuceConnectionProvider connectionProvider) {
        Assert.notNull((Object)connectionProvider, (String)"LettuceConnectionProvider must not be null!");
        this.connectionProvider = connectionProvider;
        this.connection = connectionProvider.getConnection(StatefulConnection.class);
    }

    @Override
    public ReactiveKeyCommands keyCommands() {
        return new LettuceReactiveKeyCommands(this);
    }

    @Override
    public ReactiveStringCommands stringCommands() {
        return new LettuceReactiveStringCommands(this);
    }

    @Override
    public ReactiveNumberCommands numberCommands() {
        return new LettuceReactiveNumberCommands(this);
    }

    @Override
    public ReactiveListCommands listCommands() {
        return new LettuceReactiveListCommands(this);
    }

    @Override
    public ReactiveSetCommands setCommands() {
        return new LettuceReactiveSetCommands(this);
    }

    @Override
    public ReactiveZSetCommands zSetCommands() {
        return new LettuceReactiveZSetCommands(this);
    }

    @Override
    public ReactiveHashCommands hashCommands() {
        return new LettuceReactiveHashCommands(this);
    }

    @Override
    public ReactiveGeoCommands geoCommands() {
        return new LettuceReactiveGeoCommands(this);
    }

    @Override
    public ReactiveHyperLogLogCommands hyperLogLogCommands() {
        return new LettuceReactiveHyperLogLogCommands(this);
    }

    @Override
    public ReactiveScriptingCommands scriptingCommands() {
        return new LettuceReactiveScriptingCommands(this);
    }

    @Override
    public ReactiveServerCommands serverCommands() {
        return new LettuceReactiveServerCommands(this);
    }

    @Override
    public Mono<String> ping() {
        return this.execute(BaseRedisReactiveCommands::ping).next();
    }

    public <T> Flux<T> execute(LettuceReactiveCallback<T> callback) {
        return Flux.defer(() -> callback.doWithCommands(this.getCommands())).onErrorMap(this.translateException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LettuceConnectionProvider lettuceConnectionProvider = this.connectionProvider;
        synchronized (lettuceConnectionProvider) {
            this.connectionProvider.release(this.connection);
            this.connection = null;
        }
    }

    protected StatefulConnection<ByteBuffer, ByteBuffer> getConnection() {
        return this.connection;
    }

    protected RedisClusterReactiveCommands<ByteBuffer, ByteBuffer> getCommands() {
        if (this.connection instanceof StatefulRedisConnection) {
            return ((StatefulRedisConnection)this.connection).reactive();
        }
        if (this.connection instanceof StatefulRedisClusterConnection) {
            return ((StatefulRedisClusterConnection)this.connection).reactive();
        }
        throw new RuntimeException("o.O unknown connection type " + this.connection);
    }

    <T> Function<Throwable, Throwable> translateException() {
        return throwable -> {
            if (throwable instanceof RuntimeException) {
                DataAccessException convertedException = (DataAccessException)((Object)((Object)LettuceConverters.exceptionConverter().convert((Object)((RuntimeException)throwable))));
                return convertedException != null ? convertedException : throwable;
            }
            return throwable;
        };
    }

    static enum ByteBufferCodec implements RedisCodec<ByteBuffer, ByteBuffer>
    {
        INSTANCE;


        public ByteBuffer decodeKey(ByteBuffer bytes) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes.remaining());
            buffer.put(bytes);
            buffer.flip();
            return buffer;
        }

        public ByteBuffer decodeValue(ByteBuffer bytes) {
            return this.decodeKey(bytes);
        }

        public ByteBuffer encodeKey(ByteBuffer key) {
            return key.duplicate();
        }

        public ByteBuffer encodeValue(ByteBuffer value) {
            return value.duplicate();
        }
    }

    static interface LettuceReactiveCallback<T> {
        public Publisher<T> doWithCommands(RedisClusterReactiveCommands<ByteBuffer, ByteBuffer> var1);
    }
}

