/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisSentinelConnection;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.util.Pool;

public class JedisConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private static final Log log = LogFactory.getLog(JedisConnectionFactory.class);
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(JedisConverters.exceptionConverter());
    private static final Method SET_TIMEOUT_METHOD;
    private static final Method GET_TIMEOUT_METHOD;
    private JedisShardInfo shardInfo;
    private String hostName = "localhost";
    private int port = 6379;
    private int timeout = 2000;
    private String password;
    private boolean usePool = true;
    private boolean useSsl = false;
    private Pool<Jedis> pool;
    private JedisPoolConfig poolConfig = new JedisPoolConfig();
    private int dbIndex = 0;
    private String clientName;
    private boolean convertPipelineAndTxResults = true;
    private RedisSentinelConfiguration sentinelConfig;
    private RedisClusterConfiguration clusterConfig;
    private JedisCluster cluster;
    private ClusterCommandExecutor clusterCommandExecutor;

    public JedisConnectionFactory() {
    }

    public JedisConnectionFactory(JedisShardInfo shardInfo) {
        this.shardInfo = shardInfo;
    }

    public JedisConnectionFactory(JedisPoolConfig poolConfig) {
        this((RedisSentinelConfiguration)null, poolConfig);
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfig) {
        this(sentinelConfig, null);
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfig, JedisPoolConfig poolConfig) {
        this.sentinelConfig = sentinelConfig;
        this.poolConfig = poolConfig != null ? poolConfig : new JedisPoolConfig();
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfig) {
        this.clusterConfig = clusterConfig;
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfig, JedisPoolConfig poolConfig) {
        this.clusterConfig = clusterConfig;
        this.poolConfig = poolConfig;
    }

    protected Jedis fetchJedisConnector() {
        try {
            if (this.usePool && this.pool != null) {
                return (Jedis)this.pool.getResource();
            }
            Jedis jedis = new Jedis(this.getShardInfo());
            jedis.connect();
            this.potentiallySetClientName(jedis);
            return jedis;
        }
        catch (Exception ex) {
            throw new RedisConnectionFailureException("Cannot get Jedis connection", ex);
        }
    }

    protected JedisConnection postProcessConnection(JedisConnection connection) {
        return connection;
    }

    public void afterPropertiesSet() {
        if (this.shardInfo == null) {
            this.shardInfo = new JedisShardInfo(this.hostName, this.port);
            if (StringUtils.hasLength((String)this.password)) {
                this.shardInfo.setPassword(this.password);
            }
            if (this.timeout > 0) {
                this.setTimeoutOn(this.shardInfo, this.timeout);
            }
        }
        if (this.usePool && this.clusterConfig == null) {
            this.pool = this.createPool();
        }
        if (this.clusterConfig != null) {
            this.cluster = this.createCluster();
        }
    }

    private Pool<Jedis> createPool() {
        if (this.isRedisSentinelAware()) {
            return this.createRedisSentinelPool(this.sentinelConfig);
        }
        return this.createRedisPool();
    }

    protected Pool<Jedis> createRedisSentinelPool(RedisSentinelConfiguration config) {
        return new JedisSentinelPool(config.getMaster().getName(), this.convertToJedisSentinelSet(config.getSentinels()), (GenericObjectPoolConfig)(this.getPoolConfig() != null ? this.getPoolConfig() : new JedisPoolConfig()), this.getTimeoutFrom(this.getShardInfo()), this.getShardInfo().getPassword(), 0, this.clientName);
    }

    protected Pool<Jedis> createRedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.getPoolConfig(), this.getShardInfo().getHost(), this.getShardInfo().getPort(), this.getTimeoutFrom(this.getShardInfo()), this.getShardInfo().getPassword(), 0, this.clientName, this.useSsl);
    }

    private JedisCluster createCluster() {
        JedisCluster cluster = this.createCluster(this.clusterConfig, (GenericObjectPoolConfig)this.poolConfig);
        this.clusterCommandExecutor = new ClusterCommandExecutor(new JedisClusterConnection.JedisClusterTopologyProvider(cluster), new JedisClusterConnection.JedisClusterNodeResourceProvider(cluster), EXCEPTION_TRANSLATION);
        return cluster;
    }

    protected JedisCluster createCluster(RedisClusterConfiguration clusterConfig, GenericObjectPoolConfig poolConfig) {
        Assert.notNull((Object)"Cluster configuration must not be null!");
        HashSet<HostAndPort> hostAndPort = new HashSet<HostAndPort>();
        for (RedisNode node : clusterConfig.getClusterNodes()) {
            hostAndPort.add(new HostAndPort(node.getHost(), node.getPort().intValue()));
        }
        int redirects = clusterConfig.getMaxRedirects() != null ? clusterConfig.getMaxRedirects() : 5;
        return StringUtils.hasText((String)this.getPassword()) ? new JedisCluster(hostAndPort, this.timeout, this.timeout, redirects, this.password, poolConfig) : new JedisCluster(hostAndPort, this.timeout, redirects, poolConfig);
    }

    public void destroy() {
        if (this.usePool && this.pool != null) {
            try {
                this.pool.destroy();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close Jedis pool", (Throwable)ex);
            }
            this.pool = null;
        }
        if (this.cluster != null) {
            try {
                this.cluster.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close Jedis cluster", (Throwable)ex);
            }
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
    }

    @Override
    public RedisConnection getConnection() {
        if (this.cluster != null) {
            return this.getClusterConnection();
        }
        Jedis jedis = this.fetchJedisConnector();
        JedisConnection connection = this.usePool ? new JedisConnection(jedis, this.pool, this.dbIndex, this.clientName) : new JedisConnection(jedis, null, this.dbIndex, this.clientName);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return this.postProcessConnection(connection);
    }

    @Override
    public RedisClusterConnection getClusterConnection() {
        if (this.cluster == null) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured!");
        }
        return new JedisClusterConnection(this.cluster, this.clusterCommandExecutor);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public JedisShardInfo getShardInfo() {
        return this.shardInfo;
    }

    public void setShardInfo(JedisShardInfo shardInfo) {
        this.shardInfo = shardInfo;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean getUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public JedisPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    public boolean isRedisSentinelAware() {
        return this.sentinelConfig != null;
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        if (!this.isRedisSentinelAware()) {
            throw new InvalidDataAccessResourceUsageException("No Sentinels configured");
        }
        return new JedisSentinelConnection(this.getActiveSentinel());
    }

    private Jedis getActiveSentinel() {
        Assert.notNull((Object)this.sentinelConfig);
        for (RedisNode node : this.sentinelConfig.getSentinels()) {
            Jedis jedis = new Jedis(node.getHost(), node.getPort().intValue());
            if (!jedis.ping().equalsIgnoreCase("pong")) continue;
            this.potentiallySetClientName(jedis);
            return jedis;
        }
        throw new InvalidDataAccessResourceUsageException("No Sentinel found");
    }

    private Set<String> convertToJedisSentinelSet(Collection<RedisNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> convertedNodes = new LinkedHashSet<String>(nodes.size());
        for (RedisNode node : nodes) {
            if (node == null) continue;
            convertedNodes.add(node.asString());
        }
        return convertedNodes;
    }

    private void potentiallySetClientName(Jedis jedis) {
        if (StringUtils.hasText((String)this.clientName)) {
            jedis.clientSetname(this.clientName);
        }
    }

    private void setTimeoutOn(JedisShardInfo shardInfo, int timeout) {
        ReflectionUtils.invokeMethod((Method)SET_TIMEOUT_METHOD, (Object)shardInfo, (Object[])new Object[]{timeout});
    }

    private int getTimeoutFrom(JedisShardInfo shardInfo) {
        return (Integer)ReflectionUtils.invokeMethod((Method)GET_TIMEOUT_METHOD, (Object)shardInfo);
    }

    static {
        Method setTimeoutMethodCandidate = ReflectionUtils.findMethod(JedisShardInfo.class, (String)"setTimeout", (Class[])new Class[]{Integer.TYPE});
        if (setTimeoutMethodCandidate == null) {
            setTimeoutMethodCandidate = ReflectionUtils.findMethod(JedisShardInfo.class, (String)"setSoTimeout", (Class[])new Class[]{Integer.TYPE});
        }
        SET_TIMEOUT_METHOD = setTimeoutMethodCandidate;
        Method getTimeoutMethodCandidate = ReflectionUtils.findMethod(JedisShardInfo.class, (String)"getTimeout");
        if (getTimeoutMethodCandidate == null) {
            getTimeoutMethodCandidate = ReflectionUtils.findMethod(JedisShardInfo.class, (String)"getSoTimeout");
        }
        GET_TIMEOUT_METHOD = getTimeoutMethodCandidate;
    }
}

