/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.domain.PredicateSpecification;
import org.springframework.data.jpa.domain.SpecificationComposition;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

@FunctionalInterface
public interface DeleteSpecification<T>
extends Serializable {
    public static <T> DeleteSpecification<T> unrestricted() {
        return (root, query, builder) -> null;
    }

    public static <T> DeleteSpecification<T> where(DeleteSpecification<T> spec) {
        Assert.notNull(spec, (String)"DeleteSpecification must not be null");
        return spec;
    }

    public static <T> DeleteSpecification<T> where(PredicateSpecification<T> spec) {
        Assert.notNull(spec, (String)"PredicateSpecification must not be null");
        return DeleteSpecification.where((Root<T> root, CriteriaDelete<T> delete, CriteriaBuilder criteriaBuilder) -> spec.toPredicate(root, criteriaBuilder));
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public DeleteSpecification<T> and(DeleteSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public DeleteSpecification<T> and(PredicateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, DeleteSpecification.where(other), CriteriaBuilder::and);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public DeleteSpecification<T> or(DeleteSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public DeleteSpecification<T> or(PredicateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, DeleteSpecification.where(other), CriteriaBuilder::or);
    }

    @Contract(value="_ -> new")
    public static <T> DeleteSpecification<T> not(DeleteSpecification<T> spec) {
        Assert.notNull(spec, (String)"Specification must not be null");
        return (root, delete, builder) -> {
            Predicate predicate = spec.toPredicate(root, delete, builder);
            return predicate != null ? builder.not((Expression)predicate) : builder.disjunction();
        };
    }

    @SafeVarargs
    public static <T> DeleteSpecification<T> allOf(DeleteSpecification<T> ... specifications) {
        return DeleteSpecification.allOf(Arrays.asList(specifications));
    }

    public static <T> DeleteSpecification<T> allOf(Iterable<DeleteSpecification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(DeleteSpecification.unrestricted(), DeleteSpecification::and);
    }

    @SafeVarargs
    public static <T> DeleteSpecification<T> anyOf(DeleteSpecification<T> ... specifications) {
        return DeleteSpecification.anyOf(Arrays.asList(specifications));
    }

    public static <T> DeleteSpecification<T> anyOf(Iterable<DeleteSpecification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(DeleteSpecification.unrestricted(), DeleteSpecification::or);
    }

    @Nullable
    public Predicate toPredicate(Root<T> var1, CriteriaDelete<T> var2, CriteriaBuilder var3);
}

