/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.cdi.JpaRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class JpaRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaRepositoryExtension.class);
    private final Map<Set<Annotation>, Bean<EntityManager>> entityManagers = new HashMap<Set<Annotation>, Bean<EntityManager>>();

    public JpaRepositoryExtension() {
        LOGGER.info("Activating CDI extension for Spring Data JPA repositories.");
    }

    <X> void processBean(@Observes ProcessBean<X> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !EntityManager.class.isAssignableFrom((Class)type)) continue;
            HashSet qualifiers = new HashSet(bean.getQualifiers());
            if (!bean.isAlternative() && this.entityManagers.containsKey(qualifiers)) continue;
            LOGGER.debug("Discovered '{}' with qualifiers {}.", (Object)EntityManager.class.getName(), qualifiers);
            this.entityManagers.put(qualifiers, (Bean<EntityManager>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            Bean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            LOGGER.info("Registering bean for '{}' with qualifiers {}.", (Object)repositoryType.getName(), (Object)qualifiers);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private <T> Bean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<EntityManager> entityManagerBean = this.entityManagers.get(qualifiers);
        if (entityManagerBean == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", EntityManager.class.getName(), qualifiers));
        }
        return new JpaRepositoryBean<T>(beanManager, entityManagerBean, qualifiers, repositoryType);
    }
}

