/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.core.AbstractDefaultIndexOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.client.support.AliasData;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultIndexOperations
extends AbstractDefaultIndexOperations
implements IndexOperations {
    private ElasticsearchRestTemplate restTemplate;

    public DefaultIndexOperations(ElasticsearchRestTemplate restTemplate, Class<?> boundClass) {
        super(restTemplate.getElasticsearchConverter(), boundClass);
        this.restTemplate = restTemplate;
    }

    public DefaultIndexOperations(ElasticsearchRestTemplate restTemplate, IndexCoordinates boundIndex) {
        super(restTemplate.getElasticsearchConverter(), boundIndex);
        this.restTemplate = restTemplate;
    }

    @Override
    protected boolean doCreate(String indexName, @Nullable Document settings) {
        CreateIndexRequest request = this.requestFactory.createIndexRequest(indexName, settings);
        return this.restTemplate.execute(client -> client.indices().create(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    protected boolean doDelete(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for delete operation");
        if (this.doExists(indexName)) {
            DeleteIndexRequest request = new DeleteIndexRequest(indexName);
            return this.restTemplate.execute(client -> client.indices().delete(request, RequestOptions.DEFAULT).isAcknowledged());
        }
        return false;
    }

    @Override
    protected boolean doExists(String indexName) {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        return this.restTemplate.execute(client -> client.indices().exists(request, RequestOptions.DEFAULT));
    }

    @Override
    protected boolean doPutMapping(IndexCoordinates index, Document mapping) {
        Assert.notNull((Object)index, (String)"No index defined for putMapping()");
        PutMappingRequest request = this.requestFactory.putMappingRequest(index, mapping);
        return this.restTemplate.execute(client -> client.indices().putMapping(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    protected Map<String, Object> doGetMapping(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for getMapping()");
        return this.restTemplate.execute(client -> {
            RestClient restClient = client.getLowLevelClient();
            Request request = new Request("GET", '/' + index.getIndexName() + "/_mapping");
            Response response = restClient.performRequest(request);
            return this.convertMappingResponse(EntityUtils.toString((HttpEntity)response.getEntity()));
        });
    }

    @Override
    protected boolean doAddAlias(AliasQuery query, IndexCoordinates index) {
        IndicesAliasesRequest request = this.requestFactory.indicesAddAliasesRequest(query, index);
        return this.restTemplate.execute(client -> client.indices().updateAliases(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    protected boolean doRemoveAlias(AliasQuery query, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        IndicesAliasesRequest indicesAliasesRequest = this.requestFactory.indicesRemoveAliasesRequest(query, index);
        return this.restTemplate.execute(client -> client.indices().updateAliases(indicesAliasesRequest, RequestOptions.DEFAULT).isAcknowledged());
    }

    @Override
    protected List<AliasMetaData> doQueryForAlias(String indexName) {
        Object aliases = null;
        return this.restTemplate.execute(client -> {
            RestClient restClient = client.getLowLevelClient();
            Response response = restClient.performRequest(new Request("GET", '/' + indexName + "/_alias/*"));
            String aliasResponse = EntityUtils.toString((HttpEntity)response.getEntity());
            return this.convertAliasResponse(aliasResponse);
        });
    }

    @Override
    protected Map<String, Object> doGetSettings(String indexName, boolean includeDefaults) {
        Assert.notNull((Object)indexName, (String)"No index defined for getSettings");
        GetSettingsRequest request = new GetSettingsRequest().indices(new String[]{indexName}).includeDefaults(includeDefaults);
        GetSettingsResponse response = this.restTemplate.execute(client -> client.indices().getSettings(request, RequestOptions.DEFAULT));
        return this.convertSettingsResponseToMap(response, indexName);
    }

    @Override
    protected void doRefresh(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for refresh()");
        this.restTemplate.execute(client -> client.indices().refresh(Requests.refreshRequest((String[])index.getIndexNames()), RequestOptions.DEFAULT));
    }

    private Map<String, Object> convertMappingResponse(String mappingResponse) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map result = null;
            JsonNode node = mapper.readTree(mappingResponse);
            node = node.findValue("mappings");
            result = (Map)mapper.readValue(mapper.writeValueAsString((Object)node), HashMap.class);
            return result;
        }
        catch (IOException e) {
            throw new UncategorizedElasticsearchException("Could not map alias response : " + mappingResponse, e);
        }
    }

    private List<AliasMetaData> convertAliasResponse(String aliasResponse) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(aliasResponse);
            node = node.findValue("aliases");
            if (node == null) {
                return Collections.emptyList();
            }
            Map aliasData = (Map)mapper.readValue(mapper.writeValueAsString((Object)node), (TypeReference)new TypeReference<Map<String, AliasData>>(){});
            Set aliasIter = aliasData.entrySet();
            ArrayList<AliasMetaData> aliasMetaDataList = new ArrayList<AliasMetaData>();
            for (Map.Entry entry : aliasIter) {
                AliasData data = (AliasData)entry.getValue();
                aliasMetaDataList.add(AliasMetaData.newAliasMetaDataBuilder((String)((String)entry.getKey())).filter(data.getFilter()).routing(data.getRouting()).searchRouting(data.getSearch_routing()).indexRouting(data.getIndex_routing()).build());
            }
            return aliasMetaDataList;
        }
        catch (IOException e) {
            throw new UncategorizedElasticsearchException("Could not map alias response : " + aliasResponse, e);
        }
    }
}

