/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.serviceregistry;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;

public class EurekaServiceRegistry
implements ServiceRegistry<EurekaRegistration> {
    private static final Log log = LogFactory.getLog(EurekaServiceRegistry.class);
    private EurekaInstanceConfigBean eurekaInstanceConfigBean;

    public EurekaServiceRegistry() {
    }

    public EurekaServiceRegistry(EurekaInstanceConfigBean eurekaInstanceConfigBean) {
        this.eurekaInstanceConfigBean = eurekaInstanceConfigBean;
    }

    public void register(EurekaRegistration reg) {
        if (this.eurekaInstanceConfigBean != null && this.eurekaInstanceConfigBean.isAsyncClientInitialization()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing client asynchronously...");
            }
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(() -> {
                this.maybeInitializeClient(reg);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Asynchronous client initialization done.");
                }
            });
        } else {
            this.maybeInitializeClient(reg);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Registering application " + reg.getApplicationInfoManager().getInfo().getAppName() + " with eureka with status " + reg.getInstanceConfig().getInitialStatus()));
        }
        reg.getApplicationInfoManager().setInstanceStatus(reg.getInstanceConfig().getInitialStatus());
        reg.getHealthCheckHandler().ifAvailable(healthCheckHandler -> reg.getEurekaClient().registerHealthCheck((HealthCheckHandler)healthCheckHandler));
    }

    private void maybeInitializeClient(EurekaRegistration reg) {
        reg.getApplicationInfoManager().getInfo();
        reg.getEurekaClient().getApplications();
    }

    public void deregister(EurekaRegistration reg) {
        if (reg.getApplicationInfoManager().getInfo() != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unregistering application " + reg.getApplicationInfoManager().getInfo().getAppName() + " with eureka with status DOWN"));
            }
            reg.getApplicationInfoManager().setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
        }
    }

    public void setStatus(EurekaRegistration registration, String status) {
        InstanceInfo info = registration.getApplicationInfoManager().getInfo();
        if ("CANCEL_OVERRIDE".equalsIgnoreCase(status)) {
            registration.getEurekaClient().cancelOverrideStatus(info);
            return;
        }
        InstanceInfo.InstanceStatus newStatus = InstanceInfo.InstanceStatus.toEnum((String)status);
        registration.getEurekaClient().setStatus(newStatus, info);
    }

    public Object getStatus(EurekaRegistration registration) {
        String appname = registration.getApplicationInfoManager().getInfo().getAppName();
        String instanceId = registration.getApplicationInfoManager().getInfo().getId();
        InstanceInfo info = registration.getEurekaClient().getInstanceInfo(appname, instanceId);
        HashMap<String, String> status = new HashMap<String, String>();
        if (info != null) {
            status.put("status", info.getStatus().toString());
            status.put("overriddenStatus", info.getOverriddenStatus().toString());
        } else {
            status.put("status", InstanceInfo.InstanceStatus.UNKNOWN.toString());
        }
        return status;
    }

    public void close() {
    }
}

