/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.vision;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.storage.Storage;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.ImageAnnotatorSettings;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.vision.CloudVisionProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.cloud.gcp.vision.CloudVisionTemplate;
import org.springframework.cloud.gcp.vision.DocumentOcrTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CloudVisionProperties.class})
@ConditionalOnClass(value={CloudVisionTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.vision.enabled"}, matchIfMissing=true)
public class CloudVisionAutoConfiguration {
    private final CloudVisionProperties cloudVisionProperties;
    private final CredentialsProvider credentialsProvider;

    public CloudVisionAutoConfiguration(CloudVisionProperties properties, CredentialsProvider credentialsProvider) throws IOException {
        this.cloudVisionProperties = properties;
        this.credentialsProvider = properties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)properties) : credentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageAnnotatorClient imageAnnotatorClient() throws IOException {
        ImageAnnotatorSettings clientSettings = ((ImageAnnotatorSettings.Builder)((ImageAnnotatorSettings.Builder)ImageAnnotatorSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(CloudVisionAutoConfiguration.class))).build();
        return ImageAnnotatorClient.create((ImageAnnotatorSettings)clientSettings);
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudVisionTemplate cloudVisionTemplate(ImageAnnotatorClient imageAnnotatorClient) {
        return new CloudVisionTemplate(imageAnnotatorClient);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cloudVisionExecutor"})
    public Executor cloudVisionExecutor() {
        ThreadPoolTaskExecutor ackExecutor = new ThreadPoolTaskExecutor();
        ackExecutor.setMaxPoolSize(this.cloudVisionProperties.getExecutorThreadsCount());
        ackExecutor.setThreadNamePrefix("gcp-cloud-vision-ocr-executor");
        ackExecutor.setDaemon(true);
        return ackExecutor;
    }

    @ConditionalOnClass(value={Storage.class})
    @ConditionalOnMissingBean(value={DocumentOcrTemplate.class})
    static class VisionOcrConfiguration {
        private final CloudVisionProperties properties;

        VisionOcrConfiguration(CloudVisionProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean
        public DocumentOcrTemplate documentOcrTemplate(ImageAnnotatorClient imageAnnotatorClient, Storage storage, @Qualifier(value="cloudVisionExecutor") Executor executor) {
            return new DocumentOcrTemplate(imageAnnotatorClient, storage, executor, this.properties.getJsonOutputBatchSize());
        }
    }
}

