/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.SpyDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class DefinitionsParser {
    private final Set<Definition> definitions = new LinkedHashSet<Definition>();
    private final Map<Definition, Field> definitionFields = new LinkedHashMap<Definition, Field>();

    DefinitionsParser() {
        this(Collections.emptySet());
    }

    DefinitionsParser(Collection<? extends Definition> existing) {
        if (existing != null) {
            this.definitions.addAll(existing);
        }
    }

    void parse(Class<?> source) {
        this.parseElement(source, null);
        ReflectionUtils.doWithFields(source, element -> this.parseElement(element, source));
    }

    private void parseElement(AnnotatedElement element, Class<?> source) {
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS);
        annotations.stream(MockBean.class).map(MergedAnnotation::synthesize).forEach(annotation -> this.parseMockBeanAnnotation((MockBean)annotation, element, source));
        annotations.stream(SpyBean.class).map(MergedAnnotation::synthesize).forEach(annotation -> this.parseSpyBeanAnnotation((SpyBean)annotation, element, source));
    }

    private void parseMockBeanAnnotation(MockBean annotation, AnnotatedElement element, Class<?> source) {
        Set<ResolvableType> typesToMock = this.getOrDeduceTypes(element, annotation.value(), source);
        Assert.state((!typesToMock.isEmpty() ? 1 : 0) != 0, () -> "Unable to deduce type to mock from " + element);
        if (StringUtils.hasLength((String)annotation.name())) {
            Assert.state((typesToMock.size() == 1 ? 1 : 0) != 0, (String)"The name attribute can only be used when mocking a single class");
        }
        for (ResolvableType typeToMock : typesToMock) {
            MockDefinition definition = new MockDefinition(annotation.name(), typeToMock, annotation.extraInterfaces(), annotation.answer(), annotation.serializable(), annotation.reset(), QualifierDefinition.forElement(element));
            this.addDefinition(element, definition, "mock");
        }
    }

    private void parseSpyBeanAnnotation(SpyBean annotation, AnnotatedElement element, Class<?> source) {
        Set<ResolvableType> typesToSpy = this.getOrDeduceTypes(element, annotation.value(), source);
        Assert.state((!typesToSpy.isEmpty() ? 1 : 0) != 0, () -> "Unable to deduce type to spy from " + element);
        if (StringUtils.hasLength((String)annotation.name())) {
            Assert.state((typesToSpy.size() == 1 ? 1 : 0) != 0, (String)"The name attribute can only be used when spying a single class");
        }
        for (ResolvableType typeToSpy : typesToSpy) {
            SpyDefinition definition = new SpyDefinition(annotation.name(), typeToSpy, annotation.reset(), annotation.proxyTargetAware(), QualifierDefinition.forElement(element));
            this.addDefinition(element, definition, "spy");
        }
    }

    private void addDefinition(AnnotatedElement element, Definition definition, String type) {
        boolean isNewDefinition = this.definitions.add(definition);
        Assert.state((boolean)isNewDefinition, () -> "Duplicate " + type + " definition " + definition);
        if (element instanceof Field) {
            Field field = (Field)element;
            this.definitionFields.put(definition, field);
        }
    }

    private Set<ResolvableType> getOrDeduceTypes(AnnotatedElement element, Class<?>[] value, Class<?> source) {
        LinkedHashSet<ResolvableType> types = new LinkedHashSet<ResolvableType>();
        for (Class<?> clazz : value) {
            types.add(ResolvableType.forClass(clazz));
        }
        if (types.isEmpty() && element instanceof Field) {
            types.add(ResolvableType.forField((Field)((Field)element), source));
        }
        return types;
    }

    Set<Definition> getDefinitions() {
        return Collections.unmodifiableSet(this.definitions);
    }

    Field getField(Definition definition) {
        return this.definitionFields.get(definition);
    }
}

