/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class CommandLineBuilder {
    private final List<String> options = new ArrayList<String>();
    private final List<URL> classpathElements = new ArrayList<URL>();
    private final String mainClass;
    private final List<String> arguments = new ArrayList<String>();

    private CommandLineBuilder(String mainClass) {
        this.mainClass = mainClass;
    }

    static CommandLineBuilder forMainClass(String mainClass) {
        return new CommandLineBuilder(mainClass);
    }

    CommandLineBuilder withJvmArguments(String ... jvmArguments) {
        if (jvmArguments != null) {
            this.options.addAll(Arrays.stream(jvmArguments).filter(Objects::nonNull).toList());
        }
        return this;
    }

    CommandLineBuilder withSystemProperties(Map<String, String> systemProperties) {
        if (systemProperties != null) {
            systemProperties.entrySet().stream().map(e -> SystemPropertyFormatter.format((String)e.getKey(), (String)e.getValue())).forEach(this.options::add);
        }
        return this;
    }

    CommandLineBuilder withClasspath(URL ... elements) {
        this.classpathElements.addAll(Arrays.asList(elements));
        return this;
    }

    CommandLineBuilder withArguments(String ... arguments) {
        if (arguments != null) {
            this.arguments.addAll(Arrays.stream(arguments).filter(Objects::nonNull).toList());
        }
        return this;
    }

    List<String> build() {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (!this.options.isEmpty()) {
            commandLine.addAll(this.options);
        }
        if (!this.classpathElements.isEmpty()) {
            commandLine.add("-cp");
            commandLine.add(ClasspathBuilder.build(this.classpathElements));
        }
        commandLine.add(this.mainClass);
        if (!this.arguments.isEmpty()) {
            commandLine.addAll(this.arguments);
        }
        return commandLine;
    }

    static class ClasspathBuilder {
        ClasspathBuilder() {
        }

        static String build(List<URL> classpathElements) {
            StringBuilder classpath = new StringBuilder();
            for (URL element : classpathElements) {
                if (!classpath.isEmpty()) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(ClasspathBuilder.toFile(element));
            }
            return classpath.toString();
        }

        private static File toFile(URL element) {
            try {
                return new File(element.toURI());
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private static class SystemPropertyFormatter {
        private SystemPropertyFormatter() {
        }

        static String format(String key, String value) {
            if (key == null) {
                return "";
            }
            if (value == null || value.isEmpty()) {
                return String.format("-D%s", key);
            }
            return String.format("-D%s=\"%s\"", key, value);
        }
    }
}

