/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.springframework.boot.loader.tools.AbstractJarWriter;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Packager;
import org.springframework.util.Assert;

public class ImagePackager
extends Packager {
    public ImagePackager(File source, File backupFile) {
        super(source);
        this.setBackupFile(backupFile);
        if (this.isAlreadyPackaged()) {
            Assert.isTrue((this.getBackupFile().exists() && this.getBackupFile().isFile() ? 1 : 0) != 0, (String)("Original source '" + String.valueOf(this.getBackupFile()) + "' is required for building an image"));
            Assert.state((!this.isAlreadyPackaged(this.getBackupFile()) ? 1 : 0) != 0, () -> "Repackaged archive file " + String.valueOf(source) + " cannot be used to build an image");
        }
    }

    public void packageImage(Libraries libraries, BiConsumer<ZipEntry, EntryWriter> exporter) throws IOException {
        this.packageImage(libraries, new DelegatingJarWriter(exporter));
    }

    private void packageImage(Libraries libraries, AbstractJarWriter writer) throws IOException {
        File source = this.isAlreadyPackaged() ? this.getBackupFile() : this.getSource();
        try (JarFile sourceJar = new JarFile(source);){
            this.write(sourceJar, libraries, writer);
        }
    }

    private static class DelegatingJarWriter
    extends AbstractJarWriter {
        private final BiConsumer<ZipEntry, EntryWriter> exporter;

        DelegatingJarWriter(BiConsumer<ZipEntry, EntryWriter> exporter) {
            this.exporter = exporter;
        }

        @Override
        protected void writeToArchive(ZipEntry entry, EntryWriter entryWriter) throws IOException {
            this.exporter.accept(entry, entryWriter);
        }
    }
}

