/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import java.util.Iterator;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.health.contributor.CompositeHealthContributors;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.util.Assert;

public interface HealthContributors
extends Iterable<Entry> {
    public @Nullable HealthContributor getContributor(String var1);

    @Override
    default public Iterator<Entry> iterator() {
        return this.stream().iterator();
    }

    public Stream<Entry> stream();

    public static HealthContributors of(HealthContributors ... contributors) {
        return new CompositeHealthContributors(contributors);
    }

    public record Entry(String name, HealthContributor contributor) {
        public Entry {
            Assert.hasText((String)name, (String)"'name' must not be empty");
            Assert.notNull((Object)contributor, (String)"'contributor' must not be null");
        }
    }
}

