/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.mail.Header;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;

final class DecodedHeader {
    private final String name;
    private final String value;

    public static DecodedHeader of(Header h) {
        String decodedName = MimeMessageParser.decodeText(h.getName());
        String decodedValue = MimeMessageParser.decodeText(h.getValue());
        return new DecodedHeader(decodedName, decodedValue);
    }

    public DecodedHeader(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecodedHeader)) {
            return false;
        }
        DecodedHeader other = (DecodedHeader)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "DecodedHeader(name=" + this.getName() + ", value=" + this.getValue() + ")";
    }
}

