/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.converter.internal.mimemessage.ImmutableDelegatingSMTPMessage;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.internal.moduleloader.ModuleLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public abstract class SpecializedMimeMessageProducer {
    abstract boolean compatibleWithEmail(@NotNull Email var1);

    final MimeMessage populateMimeMessage(final @NotNull Email email, @NotNull Session session) throws MessagingException, UnsupportedEncodingException {
        MiscUtil.checkArgumentNotEmpty((Object)email, (String)"email is missing");
        MiscUtil.checkArgumentNotEmpty((Object)session, (String)"session is needed, it cannot be attached later");
        Object message = new MimeMessage(session){

            protected void updateMessageID() throws MessagingException {
                if (MiscUtil.valueNullOrEmpty((Object)email.getId())) {
                    super.updateMessageID();
                } else {
                    this.setHeader("Message-ID", email.getId());
                }
            }

            public String toString() {
                try {
                    return String.format("MimeMessage<id:%s, subject:%s>", super.getMessageID(), super.getSubject());
                }
                catch (MessagingException e) {
                    throw new IllegalStateException("should not reach here");
                }
            }
        };
        MimeMessageHelper.setSubject(email, message);
        MimeMessageHelper.setFrom(email, message);
        MimeMessageHelper.setReplyTo(email, (Message)message);
        MimeMessageHelper.setRecipients(email, (Message)message);
        this.populateMimeMessageMultipartStructure((MimeMessage)message, email);
        MimeMessageHelper.setHeaders(email, (Message)message);
        message.setSentDate(Optional.ofNullable(email.getSentDate()).orElse(new Date()));
        if (email.getPkcs12ConfigForSmimeSigning() != null) {
            message = ModuleLoader.loadSmimeModule().signMessageWithSmime(session, message, email.getPkcs12ConfigForSmimeSigning());
        }
        if (email.getX509CertificateForSmimeEncryption() != null) {
            message = ModuleLoader.loadSmimeModule().encryptMessageWithSmime(session, message, email.getX509CertificateForSmimeEncryption());
        }
        if (email.getDkimConfig() != null) {
            message = ModuleLoader.loadDKIMModule().signMessageWithDKIM(message, email.getDkimConfig(), (Recipient)Preconditions.checkNonEmptyArgument((Object)email.getFromRecipient(), (String)"fromRecipient"));
        }
        if (email.getBounceToRecipient() != null) {
            message = new ImmutableDelegatingSMTPMessage((MimeMessage)message, email.getBounceToRecipient().getAddress());
        }
        return message;
    }

    abstract void populateMimeMessageMultipartStructure(MimeMessage var1, Email var2) throws MessagingException;

    static boolean emailContainsMixedContent(@NotNull Email email) {
        return !email.getAttachments().isEmpty() || email.getEmailToForward() != null;
    }

    static boolean emailContainsRelatedContent(@NotNull Email email) {
        return !email.getEmbeddedImages().isEmpty();
    }

    static boolean emailContainsAlternativeContent(@NotNull Email email) {
        return (email.getPlainText() != null ? 1 : 0) + (email.getHTMLText() != null ? 1 : 0) + (email.getCalendarText() != null ? 1 : 0) > 1;
    }
}

