/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.OptionalClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;

public class OptionalPropertyFinder<T>
extends PropertyFinder<Optional<T>> {
    private final OptionalClassMeta<T> optionalClassMeta;
    private final PropertyFinder<T> propertyFinder;
    private final ClassMeta<T> innerMeta;

    public OptionalPropertyFinder(OptionalClassMeta<T> optionalClassMeta, boolean selfScoreFullName) {
        super(selfScoreFullName);
        this.optionalClassMeta = optionalClassMeta;
        this.innerMeta = optionalClassMeta.getInnerMeta();
        this.propertyFinder = this.innerMeta != null ? this.innerMeta.newPropertyFinder() : null;
    }

    @Override
    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, Object[] properties, final PropertyFinder.FoundProperty<Optional<T>> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter) {
        propertyFinderTransformer.apply(this.propertyFinder).lookForProperties(propertyNameMatcher, properties, new PropertyFinder.FoundProperty<T>(){

            @Override
            public <P extends PropertyMeta<T, ?>> void found(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                matchingProperties.found(OptionalPropertyFinder.this.getSubPropertyMeta(propertyMeta), selectionCallback, score, typeAffinityScorer);
            }
        }, score, allowSelfReference, propertyFinderTransformer, typeAffinityScorer, propertyFilter);
    }

    private <I, E> PropertyMeta<Optional<T>, E> getSubPropertyMeta(PropertyMeta<I, ?> property) {
        return new SubPropertyMeta(this.optionalClassMeta.getReflectionService(), this.optionalClassMeta.getProperty(), property);
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.optionalClassMeta.getInstantiatorDefinitions();
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        if (owner.equals(this.optionalClassMeta.getProperty())) {
            return this.propertyFinder;
        }
        throw new IllegalArgumentException("Unexpected owner " + owner);
    }

    @Override
    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        return this.getSubPropertyFinder(subPropertyMeta.getOwnerProperty());
    }

    @Override
    public Type getOwnerType() {
        return this.optionalClassMeta.getType();
    }
}

