/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.simpleflatmapper.reflect.DefaultReflectionService;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.ObjectGetterFactory;
import org.simpleflatmapper.reflect.ObjectSetterFactory;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.asm.AsmFactoryProvider;
import org.simpleflatmapper.reflect.meta.AliasProvider;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ProducerServiceLoader;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public abstract class ReflectionService
implements AsmFactoryProvider {
    private static final AsmFactory _defaultAsmFactory = new AsmFactory(ReflectionService.class.getClassLoader());

    public abstract void registerClassMeta(Type var1, ClassMeta<?> var2);

    public abstract ObjectSetterFactory getObjectSetterFactory();

    public abstract ObjectGetterFactory getObjectGetterFactory();

    public abstract InstantiatorFactory getInstantiatorFactory();

    public abstract boolean isAsmActivated();

    public final <T> ClassMeta<T> getClassMeta(Class<T> target) {
        return this.getClassMeta((Type)target);
    }

    public abstract <T> ClassMeta<T> getClassMeta(Type var1);

    public abstract <T> ClassMeta<T> getClassMetaExtraInstantiator(Type var1, Member var2);

    public abstract String getColumnName(Method var1);

    public abstract String getColumnName(Field var1);

    public final List<InstantiatorDefinition> extractInstantiator(Type target) throws IOException {
        return this.extractInstantiator(target, null);
    }

    public abstract List<InstantiatorDefinition> extractInstantiator(Type var1, Member var2) throws IOException;

    public abstract ReflectionService withAliasProvider(AliasProvider var1);

    public abstract ReflectionService withBuilderIgnoresNullValues(boolean var1);

    public abstract ReflectionService withSelfScoreFullName(boolean var1);

    public abstract boolean builderIgnoresNullValues();

    public abstract boolean selfScoreFullName();

    public abstract void registerBuilder(String var1, DefaultBuilderSupplier var2);

    public static ReflectionService newInstance() {
        return ReflectionService.newInstance(true);
    }

    public static ReflectionService newInstance(boolean useAsmGeneration) {
        return new DefaultReflectionService(useAsmGeneration && ReflectionService.canSeeSetterFromContextClassLoader() ? _defaultAsmFactory : null);
    }

    public static ReflectionService disableAsm() {
        return ReflectionService.newInstance(false);
    }

    private static boolean canSeeSetterFromContextClassLoader() {
        try {
            Class.forName(Setter.class.getName(), false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class DefaultBuilderSupplier
    implements UnaryFactory<Type, Member> {
        private final String clazzName;
        private final String methodName;

        public DefaultBuilderSupplier(String clazzName, String methodName) {
            this.clazzName = clazzName;
            this.methodName = methodName;
        }

        public Member newInstance(Type type) {
            try {
                Class<?> builderClazz = TypeHelper.toClass((Type)type).getClassLoader().loadClass(this.clazzName);
                if (this.methodName != null) {
                    return builderClazz.getMethod(this.methodName, new Class[0]);
                }
                return builderClazz.getConstructor(new Class[0]);
            }
            catch (ClassNotFoundException e) {
                return (Member)ErrorHelper.rethrow((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                return (Member)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface PassThrough {
        public String value() default "value";
    }

    public static interface BuilderProducer
    extends ProducerServiceLoader.Producer<Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>> {
    }

    public static interface ClassMetaFactoryProducer
    extends ProducerServiceLoader.Producer<UnaryFactory<ReflectionService, ClassMeta<?>>> {
    }
}

