/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;

public class PropertyMatchingScore
implements Comparable<PropertyMatchingScore> {
    private final int selfNumberOfProperties;
    private final int nbMatch;
    private final int verticalDepth;
    private final int horizontalDepth;
    private final boolean selfScoreFullName;

    private PropertyMatchingScore(int selfNumberOfProperties, int nbMatch, int verticalDepth, int horizontalDepth, boolean selfScoreFullName) {
        this.nbMatch = nbMatch;
        this.selfNumberOfProperties = selfNumberOfProperties;
        this.verticalDepth = verticalDepth;
        this.horizontalDepth = horizontalDepth;
        this.selfScoreFullName = selfScoreFullName;
    }

    @Override
    public int compareTo(PropertyMatchingScore o) {
        if (this.selfNumberOfProperties < o.selfNumberOfProperties) {
            return -1;
        }
        if (this.selfNumberOfProperties > o.selfNumberOfProperties) {
            return 1;
        }
        if (this.nbMatch < o.nbMatch) {
            return 1;
        }
        if (this.nbMatch > o.nbMatch) {
            return -1;
        }
        if (this.verticalDepth < o.verticalDepth) {
            return -1;
        }
        if (this.verticalDepth > o.verticalDepth) {
            return 1;
        }
        if (this.horizontalDepth < o.horizontalDepth) {
            return -1;
        }
        if (this.horizontalDepth > o.horizontalDepth) {
            return 1;
        }
        return 0;
    }

    public PropertyMatchingScore speculative() {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.verticalDepth, this.horizontalDepth + 1, this.selfScoreFullName);
    }

    public PropertyMatchingScore matches(PropertyNameMatcher property) {
        return this.matches(property.toString());
    }

    public PropertyMatchingScore matches(String property) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch + property.length(), this.verticalDepth, this.horizontalDepth + 1, this.selfScoreFullName);
    }

    public String toString() {
        return "{selfNumberOfProperties=" + this.selfNumberOfProperties + ", nbMatch=" + this.nbMatch + ", horizontalDepth=" + this.horizontalDepth + "}";
    }

    public PropertyMatchingScore arrayIndex(int i) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.verticalDepth, this.horizontalDepth + i, this.selfScoreFullName);
    }

    public PropertyMatchingScore speculativeArrayIndex(int i) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.verticalDepth + i, this.horizontalDepth, this.selfScoreFullName);
    }

    public PropertyMatchingScore tupleIndex(int i) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.verticalDepth, this.horizontalDepth + i, this.selfScoreFullName);
    }

    public PropertyMatchingScore self(int numberOfProperties, String propName) {
        return new PropertyMatchingScore(this.selfNumberOfProperties + numberOfProperties, this.nbMatch + this.selfNbMatch(numberOfProperties, propName), this.verticalDepth, this.horizontalDepth + 1, this.selfScoreFullName);
    }

    private int selfNbMatch(int numberOfProperties, String propName) {
        return this.selfScoreFullName && numberOfProperties == 0 ? propName.length() : 0;
    }

    public PropertyMatchingScore self(ClassMeta propertyMeta, String propName) {
        return this.self(propertyMeta.getNumberOfProperties(), propName);
    }

    public static PropertyMatchingScore newInstance(boolean selfScoreFullName) {
        return new PropertyMatchingScore(0, 0, 0, 0, selfScoreFullName);
    }
}

