/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import org.simpleflatmapper.reflect.meta.AbstractIndexPropertyFinder;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ArrayElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.BooleanSupplier;
import org.simpleflatmapper.util.Predicate;

public class ArrayPropertyFinder<T, E>
extends AbstractIndexPropertyFinder<T> {
    public ArrayPropertyFinder(ArrayClassMeta<T, E> arrayClassMeta, Predicate<PropertyMeta<?, ?>> propertyFilter, boolean selfScoreFullName) {
        super(arrayClassMeta, propertyFilter, selfScoreFullName);
    }

    @Override
    protected IndexedElement<T, E> getIndexedElement(IndexedColumn indexedColumn) {
        while (this.elements.size() <= indexedColumn.getIndexValue()) {
            this.elements.add(new IndexedElement<T, E>(this.newElementPropertyMeta(this.elements.size(), "element" + this.elements.size()), ((ArrayClassMeta)this.classMeta).getElementClassMeta(), this.propertyFilter));
        }
        return (IndexedElement)this.elements.get(indexedColumn.getIndexValue());
    }

    private PropertyMeta<T, E> newElementPropertyMeta(int index, String name) {
        ArrayClassMeta arrayClassMeta = (ArrayClassMeta)this.classMeta;
        BooleanSupplier appendSetter = new BooleanSupplier(){

            public boolean getAsBoolean() {
                for (int i = 1; i < ArrayPropertyFinder.this.elements.size(); ++i) {
                    if (!((IndexedElement)ArrayPropertyFinder.this.elements.get(i)).hasAnyProperty()) continue;
                    return false;
                }
                return true;
            }
        };
        return new ArrayElementPropertyMeta(name, this.classMeta.getType(), arrayClassMeta.getReflectionService(), index, arrayClassMeta, arrayClassMeta.newSetterFactory(appendSetter), arrayClassMeta.newGetterFactory());
    }

    @Override
    protected void extrapolateIndex(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
        ClassMeta elementClassMeta = ((ArrayClassMeta)this.classMeta).getElementClassMeta();
        PropertyMeta property = elementClassMeta.newPropertyFinder(this.propertyFilter).findProperty(propertyNameMatcher, properties, typeAffinityScorer);
        if (property != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                IndexedElement element = (IndexedElement)this.elements.get(i);
                ExtrapolateFoundProperty matchingProperties = new ExtrapolateFoundProperty(element, foundProperty);
                this.lookForAgainstColumn(new IndexedColumn(i, propertyNameMatcher), properties, matchingProperties, score.speculativeArrayIndex(i), propertyFinderTransformer, typeAffinityScorer);
                if (!matchingProperties.hasFound()) continue;
                return;
            }
            int index = this.elements.size();
            this.lookForAgainstColumn(new IndexedColumn(index, propertyNameMatcher), properties, foundProperty, score.speculativeArrayIndex(index), propertyFinderTransformer, typeAffinityScorer);
        }
    }

    @Override
    protected boolean indexMatches(PropertyMeta<T, ?> propertyMeta, PropertyMeta<?, ?> owner) {
        if (owner == propertyMeta) {
            return true;
        }
        if (propertyMeta instanceof ArrayElementPropertyMeta && owner instanceof ArrayElementPropertyMeta) {
            return ((ArrayElementPropertyMeta)propertyMeta).getIndex() == ((ArrayElementPropertyMeta)owner).getIndex();
        }
        return false;
    }

    @Override
    protected PropertyFinder<?> registerProperty(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        PropertyMeta<?, ?> ownerProperty = subPropertyMeta.getOwnerProperty();
        if (ownerProperty instanceof ArrayElementPropertyMeta) {
            ArrayElementPropertyMeta arrayElementPropertyMeta = (ArrayElementPropertyMeta)ownerProperty;
            IndexedElement<T, E> indexedElement = this.getIndexedElement(new IndexedColumn(arrayElementPropertyMeta.getIndex(), null));
            return indexedElement.getPropertyFinder();
        }
        throw new IllegalArgumentException("Illegal owner expected ArrayElementPropertyMeta got " + subPropertyMeta);
    }

    @Override
    protected boolean isValidIndex(IndexedColumn indexedColumn) {
        return indexedColumn.getIndexValue() >= 0;
    }

    private static class ExtrapolateFoundProperty<T>
    implements PropertyFinder.FoundProperty<T> {
        private final IndexedElement element;
        private final PropertyFinder.FoundProperty foundProperty;
        private boolean found;

        public ExtrapolateFoundProperty(IndexedElement element, PropertyFinder.FoundProperty foundProperty) {
            this.element = element;
            this.foundProperty = foundProperty;
        }

        @Override
        public <P extends PropertyMeta<T, ?>> void found(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
            String pathCheck;
            if (propertyMeta instanceof ArrayElementPropertyMeta) {
                pathCheck = "{this}";
            } else if (propertyMeta.isSubProperty()) {
                pathCheck = ((SubPropertyMeta)propertyMeta).getSubProperty().getPath();
            } else {
                throw new IllegalArgumentException("Excepted match " + propertyMeta);
            }
            if (!this.element.hasProperty(pathCheck)) {
                this.foundProperty.found(propertyMeta, selectionCallback, score, typeAffinityScorer);
                this.found = true;
            }
        }

        public boolean hasFound() {
            return this.found;
        }
    }
}

