/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.IndexedBooleanArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedByteArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedCharArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedDoubleArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedFloatArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedIntArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedListGetter;
import org.simpleflatmapper.reflect.getter.IndexedLongArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedObjectArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedShortArrayGetter;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ArrayPropertyFinder;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.AppendCollectionSetter;
import org.simpleflatmapper.reflect.setter.IndexedBooleanArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedByteArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedCharArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedDoubleArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedFloatArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedIntArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedListSetter;
import org.simpleflatmapper.reflect.setter.IndexedLongArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedObjectArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedShortArraySetter;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.BooleanSupplier;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.IntFactory;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class ArrayClassMeta<T, E>
implements ClassMeta<T> {
    private final ReflectionService reflectionService;
    private final Type elementTarget;
    private final ClassMeta<E> elementClassMeta;
    private final Type type;
    private final Class<?> implementationType;
    private final InstantiatorDefinition constructor;

    public ArrayClassMeta(Type type, Type elementTarget, ReflectionService reflectionService) {
        this.type = type;
        this.elementTarget = elementTarget;
        this.reflectionService = reflectionService;
        this.elementClassMeta = reflectionService.getClassMeta(elementTarget);
        this.implementationType = this.findImpl(type);
        this.constructor = this.getConstructor(type);
    }

    private InstantiatorDefinition getConstructor(Type type) {
        if (TypeHelper.isArray((Type)type)) {
            return null;
        }
        try {
            return new ExecutableInstantiatorDefinition(this.implementationType.getDeclaredConstructor(new Class[0]), new Parameter[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor for " + this.implementationType);
        }
    }

    private Class<?> findImpl(Type type) {
        Class clazz = TypeHelper.toClass((Type)type);
        if (clazz.isArray()) {
            return clazz;
        }
        if (clazz.isInterface()) {
            if (List.class.equals((Object)clazz) || Collection.class.equals((Object)clazz) || Iterable.class.equals((Object)clazz)) {
                return ArrayList.class;
            }
            if (Set.class.equals((Object)clazz)) {
                return HashSet.class;
            }
        } else if (!Modifier.isAbstract(clazz.getModifiers())) {
            return clazz;
        }
        throw new IllegalArgumentException("Unknown List impl for " + type);
    }

    public ClassMeta<E> getElementClassMeta() {
        return this.elementClassMeta;
    }

    public Type getElementTarget() {
        return this.elementTarget;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder(Predicate<PropertyMeta<?, ?>> propertyFilter) {
        return new ArrayPropertyFinder(this, propertyFilter, this.reflectionService.selfScoreFullName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean isArray() {
        return TypeHelper.isArray((Type)this.type);
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        if (this.constructor != null) {
            return Arrays.asList(this.constructor);
        }
        return Collections.emptyList();
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<T, ?>> consumer) {
        throw new UnsupportedOperationException("Cannot forEach property on array as variable");
    }

    @Override
    public int getNumberOfProperties() {
        return 10000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, E> IntFactory<Setter<T, E>> newSetterFactory(final BooleanSupplier appendSetter) {
        if (TypeHelper.isArray((Type)this.type)) {
            Type elementType = TypeHelper.getComponentTypeOfListOrArray((Type)this.type);
            if (!TypeHelper.isPrimitive((Type)elementType)) return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    return new IndexedObjectArraySetter(i);
                }
            };
            if (Boolean.TYPE.equals(elementType)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedBooleanArraySetter(i);
                    }
                };
            }
            if (Byte.TYPE.equals(elementType)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedByteArraySetter(i);
                    }
                };
            }
            if (Character.TYPE.equals(elementType)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedCharArraySetter(i);
                    }
                };
            }
            if (Short.TYPE.equals(elementType)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedShortArraySetter(i);
                    }
                };
            }
            if (Integer.TYPE.equals(elementType)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedIntArraySetter(i);
                    }
                };
            }
            if (Long.TYPE.equals(elementType)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedLongArraySetter(i);
                    }
                };
            }
            if (Float.TYPE.equals(elementType)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedFloatArraySetter(i);
                    }
                };
            }
            if (!Double.TYPE.equals(elementType)) return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    return NullSetter.NULL_SETTER;
                }
            };
            return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    return new IndexedDoubleArraySetter(i);
                }
            };
        }
        if (TypeHelper.isAssignable(List.class, this.implementationType)) {
            return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    if (appendSetter.getAsBoolean() && i == 0) {
                        return AppendCollectionSetter.INSTANCE;
                    }
                    return new IndexedListSetter(i);
                }
            };
        }
        if (!TypeHelper.isAssignable(Collection.class, this.implementationType)) return new /* invalid duplicate definition of identical inner class */;
        return new IntFactory<Setter<T, E>>(){

            public Setter<T, E> newInstance(int i) {
                return AppendCollectionSetter.INSTANCE;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, E> IntFactory<Getter<T, E>> newGetterFactory() {
        if (TypeHelper.isArray((Type)this.type)) {
            Type elementType = TypeHelper.getComponentTypeOfListOrArray((Type)this.type);
            if (!TypeHelper.isPrimitive((Type)elementType)) return new IntFactory<Getter<T, E>>(){

                public Getter<T, E> newInstance(int i) {
                    return new IndexedObjectArrayGetter(i);
                }
            };
            if (Boolean.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedBooleanArrayGetter(i);
                    }
                };
            }
            if (Byte.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedByteArrayGetter(i);
                    }
                };
            }
            if (Character.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedCharArrayGetter(i);
                    }
                };
            }
            if (Short.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedShortArrayGetter(i);
                    }
                };
            }
            if (Integer.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedIntArrayGetter(i);
                    }
                };
            }
            if (Long.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedLongArrayGetter(i);
                    }
                };
            }
            if (Float.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedFloatArrayGetter(i);
                    }
                };
            }
            if (!Double.TYPE.equals(elementType)) return new IntFactory<Getter<T, E>>(){

                public Getter<T, E> newInstance(int i) {
                    return NullGetter.getter();
                }
            };
            return new IntFactory<Getter<T, E>>(){

                public Getter<T, E> newInstance(int i) {
                    return new IndexedDoubleArrayGetter(i);
                }
            };
        }
        if (!TypeHelper.isAssignable(List.class, this.implementationType)) return new /* invalid duplicate definition of identical inner class */;
        return new IntFactory<Getter<T, E>>(){

            public Getter<T, E> newInstance(int i) {
                return new IndexedListGetter(i);
            }
        };
    }
}

