/* *##%
 * Copyright (c) 2009 ruchaud. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty.multistorage;

import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyTransaction;

/**
 *
 * @author ruchaud
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public class WikittyExtensionMultiStorage implements WikittyExtensionStorage {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyExtensionMultiStorage.class);

    protected MultiStorageConfiguration configuration;

    public WikittyExtensionMultiStorage(MultiStorageConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public UpdateResponse store(WikittyTransaction transaction, Collection<WikittyExtension> extensions) {
        List<WikittyExtensionStorage> extensionStorageMasters = configuration.getExtensionStorageMasters();
        for (WikittyExtensionStorage extensionStorage : extensionStorageMasters) {
            extensionStorage.store(transaction, extensions);
        }

        List<WikittyExtensionStorage> extensionStorageReplications = configuration.getExtensionStorageReplications();
        for (WikittyExtensionStorage extensionStorage : extensionStorageReplications) {
            extensionStorage.store(transaction, extensions);
        }

        // nothing to put in result
        UpdateResponse result = new UpdateResponse();
        return result;
    }

    @Override
    public boolean exists(WikittyTransaction transaction, String id) {
        WikittyExtensionStorage currentMasterExtensionStorage = configuration.getCurrentMasterExtensionStorage();
        boolean result = currentMasterExtensionStorage.exists(transaction, id);
        return result;
    }

    @Override
    public List<String> getAllExtensionIds(WikittyTransaction transaction) {
        WikittyExtensionStorage currentMasterExtensionStorage = configuration.getCurrentMasterExtensionStorage();
        List<String> result = currentMasterExtensionStorage.getAllExtensionIds(transaction);
        return result;
    }

    @Override
    public List<String> getAllExtensionsRequires(
            WikittyTransaction transaction, String extensionName) {
        WikittyExtensionStorage currentMasterExtensionStorage = configuration.getCurrentMasterExtensionStorage();
        List<String> result = currentMasterExtensionStorage.getAllExtensionsRequires(transaction, extensionName);
        return result;
    }
    
    @Override
    public String getLastVersion(WikittyTransaction transaction, String extName) {
        WikittyExtensionStorage currentMasterExtensionStorage = configuration.getCurrentMasterExtensionStorage();
        String result = currentMasterExtensionStorage.getLastVersion(transaction, extName);
        return result;
    }

    @Override
    public WikittyExtension restore(WikittyTransaction transaction, String name, String version) throws WikittyException {
        WikittyExtensionStorage currentMasterExtensionStorage = configuration.getCurrentMasterExtensionStorage();
        WikittyExtension result = currentMasterExtensionStorage.restore(transaction, name, version);
        return result;
    }

    @Override
    public void clear(WikittyTransaction transaction) {
        List<WikittyExtensionStorage> extensionStorageMasters = configuration.getExtensionStorageMasters();
        for (WikittyExtensionStorage master : extensionStorageMasters) {
            master.clear(transaction);
        }

        List<WikittyExtensionStorage> extensionStorageReplications = configuration.getExtensionStorageReplications();
        for (WikittyExtensionStorage extensionStorage : extensionStorageReplications) {
            extensionStorage.clear(transaction);
        }
    }

}
