/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.Map;

/**
 * WikittySearchEngin is used to abstract search engin used in WikittyService.
 *
 *
 * @author poussin
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public interface WikittySearchEngin {

    /**
     * Remove all data in index
     */
    public void clear(WikittyTransaction transaction);

    /**
     * Store wikitty in storage
     * @return information usefull for client side update data
     */
    public UpdateResponse store(WikittyTransaction transaction,
            Collection<Wikitty> wikitties);

    /**
     * Delete all object with idList argument. If id is not valid or don't exist.
     * 
     * @param idList list of ids to delete
     * @return <code>UpdateResponse</code>>
     * @throws WikittyException
     */
    public UpdateResponse delete(WikittyTransaction transaction,
            Collection<String> idList) throws WikittyException;

    /**
     * Delete all object with idList argument. idList is directly passed to search engine
     * and is processed without any other kind of treatment.
     * 
     * @param idList list of ids to delete
     * @return <code>UpdateResponse</code>>
     * @throws WikittyException
     */
    public void delete(Collection<String> idList) throws WikittyException;
    
    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria);

    /**
     * Find count of child for a node
     * @param w
     * @return
     */
    public Integer findNodeCount(WikittyTransaction transaction, Wikitty w, Criteria filter);

    /**
     * Find all children ids with count for a node wikitty.
     * @param w
     * @return
     */
    public Map<String, Integer> findAllChildrenCount(WikittyTransaction transaction, Wikitty w, Criteria filter);

}
