/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.StringUtil;

public class MultiPartResponse {
    private static Log log = LogFactory.getLog(MultiPartResponse.class);
    private static byte[] __CRLF;
    private static byte[] __DASHDASH;
    private String boundary;
    private byte[] boundaryBytes;
    private OutputStream out = null;
    private boolean inPart = false;

    private MultiPartResponse() {
        try {
            this.boundary = "jetty" + System.identityHashCode(this) + Long.toString(System.currentTimeMillis(), 36);
            this.boundaryBytes = this.boundary.getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            System.exit(1);
        }
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public MultiPartResponse(OutputStream out) throws IOException {
        this();
        this.out = out;
        this.inPart = false;
    }

    public MultiPartResponse(HttpResponse response) throws IOException {
        this();
        response.setField("Content-Type", "multipart/mixed;boundary=" + this.boundary);
        this.out = response.getOutputStream();
        this.inPart = false;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        for (int i = 0; headers != null && i < headers.length; ++i) {
            this.out.write(headers[i].getBytes(StringUtil.__ISO_8859_1));
            this.out.write(__CRLF);
        }
        this.out.write(__CRLF);
    }

    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
    }

    static {
        try {
            __CRLF = "\r\n".getBytes(StringUtil.__ISO_8859_1);
            __DASHDASH = "--".getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            System.exit(1);
        }
    }
}

