/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.RemoteKeyboard;
import org.openqa.selenium.remote.RemoteMouse;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.UselessFileDetector;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWebDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath,
HasInputDevices,
HasCapabilities {
    private final ErrorHandler errorHandler = new ErrorHandler();
    private CommandExecutor executor;
    private Capabilities capabilities;
    private SessionId sessionId;
    private FileDetector fileDetector = new UselessFileDetector();
    private ExecuteMethod executeMethod;
    private JsonToWebElementConverter converter;
    private final RemoteKeyboard keyboard;
    private final RemoteMouse mouse;

    protected RemoteWebDriver() {
        this.init();
        this.keyboard = new RemoteKeyboard(this.executeMethod);
        this.mouse = new RemoteMouse(this.executeMethod);
    }

    public RemoteWebDriver(CommandExecutor executor, Capabilities desiredCapabilities) {
        this.executor = executor;
        this.init();
        this.keyboard = new RemoteKeyboard(this.executeMethod);
        this.mouse = new RemoteMouse(this.executeMethod);
        this.startClient();
        this.startSession(desiredCapabilities);
    }

    public RemoteWebDriver(Capabilities desiredCapabilities) {
        this((URL)null, desiredCapabilities);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        this(new HttpCommandExecutor(remoteAddress), desiredCapabilities);
    }

    private void init() {
        this.converter = new JsonToWebElementConverter(this);
        this.executeMethod = new ExecuteMethod(this);
    }

    public void setFileDetector(FileDetector detector) {
        if (detector == null) {
            throw new WebDriverException("You may not set a file detector that is null");
        }
        this.fileDetector = detector;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    protected void startSession(Capabilities desiredCapabilities) {
        Platform platform;
        Response response = this.execute("newSession", (Map<String, ?>)ImmutableMap.of((Object)"desiredCapabilities", (Object)desiredCapabilities));
        Map rawCapabilities = (Map)response.getValue();
        DesiredCapabilities returnedCapabilities = new DesiredCapabilities();
        for (Map.Entry entry : rawCapabilities.entrySet()) {
            if ("platform".equals(entry.getKey())) continue;
            returnedCapabilities.setCapability((String)entry.getKey(), entry.getValue());
        }
        String platformString = (String)rawCapabilities.get("platform");
        try {
            platform = platformString == null || "".equals(platformString) ? Platform.ANY : Platform.valueOf((String)platformString);
        }
        catch (IllegalArgumentException e) {
            platform = Platform.extractFromSysProperty((String)platformString);
        }
        returnedCapabilities.setPlatform(platform);
        this.capabilities = returnedCapabilities;
        this.sessionId = new SessionId(response.getSessionId());
    }

    protected void startClient() {
    }

    protected void stopClient() {
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public CommandExecutor getCommandExecutor() {
        return this.executor;
    }

    protected void setCommandExecutor(CommandExecutor executor) {
        this.executor = executor;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void get(String url) {
        this.execute("get", (Map<String, ?>)ImmutableMap.of((Object)"url", (Object)url));
    }

    public String getTitle() {
        Response response = this.execute("getTitle");
        Object value = response.getValue();
        return value == null ? "" : value.toString();
    }

    public String getCurrentUrl() {
        return this.execute("getCurrentUrl").getValue().toString();
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    protected WebElement findElement(String by, String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        Response response = this.execute("findElement", (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        return (WebElement)response.getValue();
    }

    protected List<WebElement> findElements(String by, String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        Response response = this.execute("findElements", (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        return (List)response.getValue();
    }

    public WebElement findElementById(String using) {
        return this.findElement("id", using);
    }

    public List<WebElement> findElementsById(String using) {
        return this.findElements("id", using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    public WebElement findElementByTagName(String using) {
        return this.findElement("tag name", using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.findElements("tag name", using);
    }

    public WebElement findElementByName(String using) {
        return this.findElement("name", using);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findElements("name", using);
    }

    public WebElement findElementByClassName(String using) {
        return this.findElement("class name", using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.findElements("class name", using);
    }

    public WebElement findElementByCssSelector(String using) {
        return this.findElement("css selector", using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findElements("css selector", using);
    }

    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    public String getPageSource() {
        return (String)this.execute("getPageSource").getValue();
    }

    public void close() {
        this.execute("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        try {
            this.execute("quit");
        }
        finally {
            this.sessionId = null;
            this.stopClient();
        }
    }

    public Set<String> getWindowHandles() {
        Response response = this.execute("getWindowHandles");
        List returnedValues = (List)response.getValue();
        return new LinkedHashSet<String>(returnedValues);
    }

    public String getWindowHandle() {
        return String.valueOf(this.execute("getCurrentWindowHandle").getValue());
    }

    public Object executeScript(String script, Object ... args) {
        if (!this.capabilities.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        ImmutableMap params = ImmutableMap.of((Object)"script", (Object)script, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
        return this.execute("executeScript", (Map<String, ?>)params).getValue();
    }

    public Object executeAsyncScript(String script, Object ... args) {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        ImmutableMap params = ImmutableMap.of((Object)"script", (Object)script, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
        return this.execute("executeAsyncScript", (Map<String, ?>)params).getValue();
    }

    private boolean isJavascriptEnabled() {
        return this.capabilities.isJavascriptEnabled();
    }

    public WebDriver.TargetLocator switchTo() {
        return new RemoteTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new RemoteNavigation();
    }

    public WebDriver.Options manage() {
        return new RemoteWebDriverOptions();
    }

    @Deprecated
    protected RemoteWebElement newRemoteWebElement() {
        RemoteWebElement toReturn = new RemoteWebElement();
        toReturn.setParent(this);
        return toReturn;
    }

    protected void setElementConverter(JsonToWebElementConverter converter) {
        this.converter = converter;
    }

    protected JsonToWebElementConverter getElementConverter() {
        return this.converter;
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        Response response;
        Command command = new Command(this.sessionId, driverCommand, parameters);
        long start = System.currentTimeMillis();
        try {
            this.log(this.sessionId, command.getName(), command);
            response = this.executor.execute(command);
            if (response == null) {
                this.log(this.sessionId, command.getName(), response);
                return null;
            }
            Object value = this.converter.apply(response.getValue());
            response.setValue(value);
            this.log(this.sessionId, command.getName(), response);
        }
        catch (RuntimeException e) {
            this.log(this.sessionId, command.getName(), e);
            throw e;
        }
        catch (Exception e) {
            this.log(this.sessionId, command.getName(), e);
            throw new WebDriverException((Throwable)e);
        }
        return this.errorHandler.throwIfResponseFailed(response, System.currentTimeMillis() - start);
    }

    protected Response execute(String command) {
        return this.execute(command, (Map<String, ?>)ImmutableMap.of());
    }

    protected ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    protected void log(SessionId sessionId, String commandName, Object toLog) {
    }

    public FileDetector getFileDetector() {
        return this.fileDetector;
    }

    private class RemoteAlert
    implements Alert {
        private final String text;

        public RemoteAlert(String text) {
            this.text = text;
        }

        public void dismiss() {
            RemoteWebDriver.this.execute("dismissAlert");
        }

        public void accept() {
            RemoteWebDriver.this.execute("acceptAlert");
        }

        public String getText() {
            return this.text;
        }

        public void sendKeys(String keysToSend) {
            RemoteWebDriver.this.execute("setAlertValue", (Map<String, ?>)ImmutableMap.of((Object)"text", (Object)keysToSend));
        }
    }

    protected class RemoteTargetLocator
    implements WebDriver.TargetLocator {
        protected RemoteTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            RemoteWebDriver.this.execute("switchToFrame", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)frameIndex));
            return RemoteWebDriver.this;
        }

        public WebDriver frame(String frameName) {
            RemoteWebDriver.this.execute("switchToFrame", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)frameName));
            return RemoteWebDriver.this;
        }

        public WebDriver frame(WebElement frameElement) {
            Object elementAsJson = new WebElementToJsonConverter().apply(frameElement);
            RemoteWebDriver.this.execute("switchToFrame", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)elementAsJson));
            return RemoteWebDriver.this;
        }

        public WebDriver window(String windowName) {
            RemoteWebDriver.this.execute("switchToWindow", (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)windowName));
            return RemoteWebDriver.this;
        }

        public WebDriver defaultContent() {
            HashMap frameId = Maps.newHashMap();
            frameId.put("id", null);
            RemoteWebDriver.this.execute("switchToFrame", frameId);
            return RemoteWebDriver.this;
        }

        public WebElement activeElement() {
            Response response = RemoteWebDriver.this.execute("getActiveElement");
            return (WebElement)response.getValue();
        }

        public Alert alert() {
            Response response = RemoteWebDriver.this.execute("getAlertText");
            return new RemoteAlert((String)response.getValue());
        }
    }

    private class RemoteNavigation
    implements WebDriver.Navigation {
        private RemoteNavigation() {
        }

        public void back() {
            RemoteWebDriver.this.execute("goBack");
        }

        public void forward() {
            RemoteWebDriver.this.execute("goForward");
        }

        public void to(String url) {
            RemoteWebDriver.this.get(url);
        }

        public void to(URL url) {
            RemoteWebDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            RemoteWebDriver.this.execute("refresh");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RemoteWebDriverOptions
    implements WebDriver.Options {
        protected RemoteWebDriverOptions() {
        }

        public void addCookie(Cookie cookie) {
            RemoteWebDriver.this.execute("addCookie", (Map<String, ?>)ImmutableMap.of((Object)"cookie", (Object)cookie));
        }

        public void deleteCookieNamed(String name) {
            RemoteWebDriver.this.execute("deleteCookie", (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)name));
        }

        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        public void deleteAllCookies() {
            RemoteWebDriver.this.execute("deleteAllCookies");
        }

        public Set<Cookie> getCookies() {
            Object returned = RemoteWebDriver.this.execute("getCookies").getValue();
            try {
                List cookies = new JsonToBeanConverter().convert(List.class, returned);
                HashSet<Cookie> toReturn = new HashSet<Cookie>();
                for (Map rawCookie : cookies) {
                    String name = (String)rawCookie.get("name");
                    String value = (String)rawCookie.get("value");
                    String path = (String)rawCookie.get("path");
                    String domain = (String)rawCookie.get("domain");
                    Boolean secure = (Boolean)rawCookie.get("secure");
                    Number expiryNum = (Number)rawCookie.get("expiry");
                    Date expiry = expiryNum == null ? null : new Date(TimeUnit.SECONDS.toMillis(expiryNum.longValue()));
                    toReturn.add(new Cookie.Builder(name, value).path(path).domain(domain).isSecure(secure.booleanValue()).expiresOn(expiry).build());
                }
                return toReturn;
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        public WebDriver.Timeouts timeouts() {
            return new RemoteTimeouts();
        }

        public WebDriver.ImeHandler ime() {
            return new RemoteInputMethodManager();
        }

        protected class RemoteTimeouts
        implements WebDriver.Timeouts {
            protected RemoteTimeouts() {
            }

            public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
                RemoteWebDriver.this.execute("implicitlyWait", (Map<String, ?>)ImmutableMap.of((Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(Math.max(0L, time), unit)));
                return this;
            }

            public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
                RemoteWebDriver.this.execute("setScriptTimeout", (Map<String, ?>)ImmutableMap.of((Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class RemoteInputMethodManager
        implements WebDriver.ImeHandler {
            protected RemoteInputMethodManager() {
            }

            public List<String> getAvailableEngines() {
                Response response = RemoteWebDriver.this.execute("imeGetAvailableEngines");
                return (List)response.getValue();
            }

            public String getActiveEngine() {
                Response response = RemoteWebDriver.this.execute("imeGetActiveEngine");
                return (String)response.getValue();
            }

            public boolean isActivated() {
                Response response = RemoteWebDriver.this.execute("imeIsActivated");
                return (Boolean)response.getValue();
            }

            public void deactivate() {
                RemoteWebDriver.this.execute("imeDeactivate");
            }

            public void activateEngine(String engine) {
                RemoteWebDriver.this.execute("imeActivateEngine", (Map<String, ?>)ImmutableMap.of((Object)"engine", (Object)engine));
            }
        }
    }
}

