/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.DoNotUseProxyPac;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.SimplePropertyDescriptor;

public class BeanToJsonConverter {
    private static final int MAX_DEPTH = 5;

    public String convert(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Object converted = this.convertObject(object, 5);
            if (converted instanceof JSONObject || converted instanceof JSONArray || converted instanceof String || converted instanceof Number) {
                return converted.toString();
            }
            return String.valueOf(object);
        }
        catch (Exception e) {
            throw new WebDriverException("Unable to convert: " + object, (Throwable)e);
        }
    }

    private Object convertUnknownObjectFromJson(Object o) {
        if (o instanceof JSONArray) {
            return this.convertJsonArray((JSONArray)o);
        }
        if (o instanceof JSONObject) {
            return this.convertJsonObject((JSONObject)o);
        }
        return o;
    }

    private Map<String, Object> convertJsonObject(JSONObject jsonObject) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        Iterator allKeys = jsonObject.keys();
        while (allKeys.hasNext()) {
            String key = (String)allKeys.next();
            try {
                toReturn.put(key, this.convertUnknownObjectFromJson(jsonObject.get(key)));
            }
            catch (JSONException e) {
                throw new IllegalStateException("Unable to access key: " + key, e);
            }
        }
        return toReturn;
    }

    private List<Object> convertJsonArray(JSONArray jsonArray) {
        ArrayList<Object> toReturn = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                toReturn.add(this.convertUnknownObjectFromJson(jsonArray.get(i)));
                continue;
            }
            catch (JSONException e) {
                throw new IllegalStateException("Cannot convert object at index: " + i, e);
            }
        }
        return toReturn;
    }

    private Object convertObject(Object toConvert, int maxDepth) throws Exception {
        if (toConvert == null) {
            return JSONObject.NULL;
        }
        if (toConvert instanceof Boolean || toConvert instanceof CharSequence || toConvert instanceof Number) {
            return toConvert;
        }
        if (toConvert.getClass().isEnum() || toConvert instanceof Enum) {
            return toConvert.toString();
        }
        if (toConvert instanceof LoggingPreferences) {
            LoggingPreferences prefs = (LoggingPreferences)toConvert;
            JSONObject converted = new JSONObject();
            for (String logType : prefs.getEnabledLogTypes()) {
                converted.put(logType, (Object)prefs.getLevel(logType));
            }
            return converted;
        }
        if (toConvert instanceof LogEntries) {
            return this.convertObject(((LogEntries)toConvert).getAll(), maxDepth - 1);
        }
        if (toConvert instanceof Map) {
            JSONObject converted = new JSONObject();
            Iterator i$ = ((Map)toConvert).entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry objectEntry;
                Map.Entry entry = objectEntry = i$.next();
                converted.put((String)entry.getKey(), this.convertObject(entry.getValue(), maxDepth - 1));
            }
            return converted;
        }
        if (toConvert instanceof JSONObject) {
            return toConvert;
        }
        if (toConvert instanceof Collection) {
            JSONArray array = new JSONArray();
            for (Object o : (Collection)toConvert) {
                array.put(this.convertObject(o, maxDepth - 1));
            }
            return array;
        }
        if (toConvert.getClass().isArray()) {
            JSONArray converted = new JSONArray();
            int length = Array.getLength(toConvert);
            for (int i = 0; i < length; ++i) {
                converted.put(this.convertObject(Array.get(toConvert, i), maxDepth - 1));
            }
            return converted;
        }
        if (toConvert instanceof SessionId) {
            JSONObject converted = new JSONObject();
            converted.put("value", (Object)toConvert.toString());
            return converted;
        }
        if (toConvert instanceof Capabilities) {
            return this.convertObject(((Capabilities)toConvert).asMap(), maxDepth - 1);
        }
        if (toConvert instanceof DoNotUseProxyPac) {
            return this.convertObject(((DoNotUseProxyPac)toConvert).asMap(), maxDepth - 1);
        }
        if (toConvert instanceof Date) {
            return TimeUnit.MILLISECONDS.toSeconds(((Date)toConvert).getTime());
        }
        if (toConvert instanceof File) {
            return ((File)toConvert).getAbsolutePath();
        }
        Method toJson = this.getToJsonMethod(toConvert);
        if (toJson != null) {
            try {
                return toJson.invoke(toConvert, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new WebDriverException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new WebDriverException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        try {
            return this.mapObject(toConvert, maxDepth - 1, toConvert instanceof Cookie);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Method getToJsonMethod(Object toConvert) {
        try {
            return toConvert.getClass().getMethod("toJson", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private Object mapObject(Object toConvert, int maxDepth, boolean skipNulls) throws Exception {
        if (maxDepth == 0) {
            return null;
        }
        JSONObject mapped = new JSONObject();
        for (SimplePropertyDescriptor pd : SimplePropertyDescriptor.getPropertyDescriptors(toConvert.getClass())) {
            if ("class".equals(pd.getName())) {
                mapped.put("class", (Object)toConvert.getClass().getName());
                continue;
            }
            Method readMethod = pd.getReadMethod();
            if (readMethod == null || readMethod.getParameterTypes().length > 0) continue;
            readMethod.setAccessible(true);
            Object result = readMethod.invoke(toConvert, new Object[0]);
            result = this.convertObject(result, maxDepth - 1);
            if (skipNulls && result == JSONObject.NULL) continue;
            mapped.put(pd.getName(), result);
        }
        return mapped;
    }
}

