/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class ReusingSocketSocketFactory
implements SocketFactory {
    private static final ReusingSocketSocketFactory DEFAULT_FACTORY = new ReusingSocketSocketFactory();
    private final HostNameResolver nameResolver;

    public static ReusingSocketSocketFactory getSocketFactory() {
        return DEFAULT_FACTORY;
    }

    public ReusingSocketSocketFactory(HostNameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public ReusingSocketSocketFactory() {
        this(null);
    }

    public Socket createSocket() {
        Socket socket = new Socket();
        try {
            socket.setReuseAddress(true);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return socket;
    }

    public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        if (sock == null) {
            sock = this.createSocket();
        }
        sock.setReuseAddress(true);
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            InetSocketAddress isa = new InetSocketAddress(localAddress, localPort);
            sock.bind(isa);
        }
        int timeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        InetSocketAddress remoteAddress = this.nameResolver != null ? new InetSocketAddress(this.nameResolver.resolve(host), port) : new InetSocketAddress(host, port);
        try {
            sock.connect(remoteAddress, timeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        return sock;
    }

    public final boolean isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return false;
    }
}

