/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.thoughtworks.selenium.Selenium;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.internal.selenesedriver.SeleneseFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteScript
implements SeleneseFunction<Object> {
    @Override
    public Object apply(Selenium selenium, Map<String, ?> args) {
        String script = this.prepareScript(args);
        String value = selenium.getEval(script);
        return this.populateReturnValue(value);
    }

    private String prepareScript(Map<String, ?> parameters) {
        String script = (String)parameters.get("script");
        script = String.format("(function() { %s })();", script).replaceAll("\\bwindow\\.", "selenium.browserbot.getCurrentWindow().").replaceAll("\\bdocument\\.", "selenium.browserbot.getDocument().");
        List args = (List)parameters.get("args");
        if (!args.isEmpty()) {
            for (int i = 0; i < args.size(); ++i) {
                script = script.replaceAll("arguments\\[\\s*" + i + "\\s*\\]", this.getArgumentValue(args.get(i)));
            }
        }
        return script;
    }

    private String getArgumentValue(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof String) {
            return String.format("'%s'", ((String)arg).replaceAll("'", "\\'"));
        }
        return String.valueOf(arg);
    }

    private Object populateReturnValue(String value) {
        if ("__undefined__".equals(value)) {
            return null;
        }
        if (value.matches("^\\d+$")) {
            return Long.parseLong(value);
        }
        if (value.matches("^\\d+\\.\\d+$")) {
            return Double.parseDouble(value);
        }
        if ("true".equals(value) || "false".equals(value)) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }
}

