/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.graphql.OsInfo;
import org.openqa.selenium.grid.graphql.Session;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

public class Node {
    private static final Json JSON = new Json();
    private final NodeId id;
    private final URI uri;
    private final Availability status;
    private final int maxSession;
    private final Duration sessionTimeout;
    private final Map<Capabilities, Integer> stereotypes;
    private final Map<org.openqa.selenium.grid.data.Session, Slot> activeSessions;
    private final String version;
    private final OsInfo osInfo;
    private final int slotCount;

    public Node(NodeId id, URI uri, Availability status, int maxSession, Duration sessionTimeout, int slotCount, Map<Capabilities, Integer> stereotypes, Map<org.openqa.selenium.grid.data.Session, Slot> activeSessions, String version, OsInfo osInfo) {
        this.id = (NodeId)Require.nonNull((String)"Node id", (Object)id);
        this.uri = (URI)Require.nonNull((String)"Node uri", (Object)uri);
        this.status = status;
        this.maxSession = maxSession;
        this.slotCount = slotCount;
        this.stereotypes = (Map)Require.nonNull((String)"Node stereotypes", stereotypes);
        this.activeSessions = (Map)Require.nonNull((String)"Active sessions", activeSessions);
        this.version = (String)Require.nonNull((String)"Grid Node version", (Object)version);
        this.osInfo = (OsInfo)Require.nonNull((String)"Grid Node OS info", (Object)osInfo);
        this.sessionTimeout = Require.positive((String)"Node session timeout", (Duration)sessionTimeout);
    }

    public List<Session> getSessions() {
        return this.activeSessions.entrySet().stream().map(this::createGraphqlSession).collect(Collectors.toUnmodifiableList());
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public int getSessionCount() {
        return this.activeSessions.size();
    }

    public NodeId getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public List<String> getActiveSessionIds() {
        return this.activeSessions.keySet().stream().map(session -> session.getId().toString()).collect(Collectors.toUnmodifiableList());
    }

    public String getStereotypes() {
        ArrayList toReturn = new ArrayList();
        for (Map.Entry<Capabilities, Integer> entry : this.stereotypes.entrySet()) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            details.put("stereotype", entry.getKey());
            details.put("slots", entry.getValue());
            toReturn.add(details);
        }
        return JSON.toJson(toReturn);
    }

    public Availability getStatus() {
        return this.status;
    }

    public String getVersion() {
        return this.version;
    }

    public OsInfo getOsInfo() {
        return this.osInfo;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    private Session createGraphqlSession(Map.Entry<org.openqa.selenium.grid.data.Session, Slot> entry) {
        org.openqa.selenium.grid.data.Session session = entry.getKey();
        Slot slot = entry.getValue();
        return new Session(session.getId().toString(), session.getCapabilities(), session.getStartTime(), session.getUri(), this.id.toString(), this.uri, slot);
    }
}

