/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v123.fetch.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v123.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v123.fetch.model.RequestId;
import org.openqa.selenium.devtools.v123.network.model.ErrorReason;
import org.openqa.selenium.devtools.v123.network.model.Request;
import org.openqa.selenium.devtools.v123.network.model.ResourceType;
import org.openqa.selenium.devtools.v123.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class RequestPaused {
    private final RequestId requestId;
    private final Request request;
    private final FrameId frameId;
    private final ResourceType resourceType;
    private final Optional<ErrorReason> responseErrorReason;
    private final Optional<Integer> responseStatusCode;
    private final Optional<String> responseStatusText;
    private final Optional<List<HeaderEntry>> responseHeaders;
    private final Optional<org.openqa.selenium.devtools.v123.network.model.RequestId> networkId;
    private final Optional<RequestId> redirectedRequestId;

    public RequestPaused(RequestId requestId, Request request, FrameId frameId, ResourceType resourceType, Optional<ErrorReason> responseErrorReason, Optional<Integer> responseStatusCode, Optional<String> responseStatusText, Optional<List<HeaderEntry>> responseHeaders, Optional<org.openqa.selenium.devtools.v123.network.model.RequestId> networkId, Optional<RequestId> redirectedRequestId) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType is required");
        this.responseErrorReason = responseErrorReason;
        this.responseStatusCode = responseStatusCode;
        this.responseStatusText = responseStatusText;
        this.responseHeaders = responseHeaders;
        this.networkId = networkId;
        this.redirectedRequestId = redirectedRequestId;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Request getRequest() {
        return this.request;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Optional<ErrorReason> getResponseErrorReason() {
        return this.responseErrorReason;
    }

    public Optional<Integer> getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public Optional<String> getResponseStatusText() {
        return this.responseStatusText;
    }

    public Optional<List<HeaderEntry>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Optional<org.openqa.selenium.devtools.v123.network.model.RequestId> getNetworkId() {
        return this.networkId;
    }

    @Beta
    public Optional<RequestId> getRedirectedRequestId() {
        return this.redirectedRequestId;
    }

    private static RequestPaused fromJson(JsonInput input) {
        RequestId requestId = null;
        Request request = null;
        FrameId frameId = null;
        ResourceType resourceType = null;
        Optional<ErrorReason> responseErrorReason = Optional.empty();
        Optional<Integer> responseStatusCode = Optional.empty();
        Optional<String> responseStatusText = Optional.empty();
        Optional<List<HeaderEntry>> responseHeaders = Optional.empty();
        Optional<org.openqa.selenium.devtools.v123.network.model.RequestId> networkId = Optional.empty();
        Optional<RequestId> redirectedRequestId = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block24;
                }
                case "request": {
                    request = (Request)input.read(Request.class);
                    continue block24;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block24;
                }
                case "resourceType": {
                    resourceType = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block24;
                }
                case "responseErrorReason": {
                    responseErrorReason = Optional.ofNullable((ErrorReason)((Object)input.read(ErrorReason.class)));
                    continue block24;
                }
                case "responseStatusCode": {
                    responseStatusCode = Optional.ofNullable(input.nextNumber().intValue());
                    continue block24;
                }
                case "responseStatusText": {
                    responseStatusText = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "responseHeaders": {
                    responseHeaders = Optional.ofNullable(input.readArray(HeaderEntry.class));
                    continue block24;
                }
                case "networkId": {
                    networkId = Optional.ofNullable((org.openqa.selenium.devtools.v123.network.model.RequestId)input.read(org.openqa.selenium.devtools.v123.network.model.RequestId.class));
                    continue block24;
                }
                case "redirectedRequestId": {
                    redirectedRequestId = Optional.ofNullable((RequestId)input.read(RequestId.class));
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestPaused(requestId, request, frameId, resourceType, responseErrorReason, responseStatusCode, responseStatusText, responseHeaders, networkId, redirectedRequestId);
    }
}

