/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.awt.Dimension;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.ElementNotDisplayedException;
import org.openqa.selenium.interactions.MoveOutsideBoundriesException;
import org.openqa.selenium.internal.interactions.BaseAction;

public class MoveToOffsetAction
extends BaseAction
implements Action {
    private final int xOffset;
    private final int yOffset;

    public MoveToOffsetAction(WebDriver parent, WebElement toElement, int x, int y) {
        super(parent, toElement);
        if (!(toElement instanceof RenderedWebElement)) {
            throw new ElementNotDisplayedException(String.format("Element %s has no screen coordinates, use a driver that renders elements on screen.", toElement));
        }
        this.xOffset = x;
        this.yOffset = y;
    }

    public void perform() {
        Dimension elementSize = ((RenderedWebElement)this.onElement).getSize();
        if (elementSize.getHeight() < (double)this.yOffset || elementSize.getWidth() < (double)this.xOffset) {
            throw new MoveOutsideBoundriesException(String.format("Attempted mouse move outside Elementboundries. Coordinates: x %d y %d, element size: %s", this.xOffset, this.yOffset, elementSize));
        }
        this.getMouse().mouseMove(this.onElement, this.xOffset, this.yOffset);
    }
}

