package scala.swing.event

import scala.swing.InternalFrame


/**
 * Base class for events generated by instances of [[InternalFrame]].
 *
 * @param source the `InternalFrame` that generated the event.
 */
abstract class InternalFrameEvent(override val source : InternalFrame) extends UIEvent

case class InternalFrameOpened(override val source : InternalFrame) extends InternalFrameEvent(source)

case class InternalFrameClosing(override val source : InternalFrame) extends InternalFrameEvent(source)

case class InternalFrameClosed(override val source : InternalFrame) extends InternalFrameEvent(source)

case class InternalFrameIconified(override val source : InternalFrame) extends InternalFrameEvent(source)

case class InternalFrameDeiconified(override val source : InternalFrame) extends InternalFrameEvent(source)

case class InternalFrameActivated(override val source : InternalFrame) extends InternalFrameEvent(source)

case class InternalFrameDeactivated(override val source : InternalFrame) extends InternalFrameEvent(source)

