/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.html.ProgressBarStateEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ProgressBarState {
    initialState{

        public String getStateClientId(FacesContext context, UIComponent component) {
            return component.getClientId(context) + ".init";
        }

        public String getStyleClass(FacesContext context, UIComponent component) {
            return HtmlUtil.concatClasses("rf-pb-init", component.getAttributes().get("initialClass"));
        }

        public void encodeContent(FacesContext context, UIComponent component) throws IOException {
            component.getFacet("initial").encodeAll(context);
        }

        public boolean hasContent(FacesContext context, UIComponent component) {
            UIComponent facet = component.getFacet("initial");
            return facet != null && facet.isRendered();
        }

        public void encodeStateForMetaComponent(FacesContext context, UIComponent component, ProgressBarStateEncoder encoder) throws IOException {
            encoder.encodeInitialState(context, component, this);
        }
    }
    ,
    progressState{

        public String getStateClientId(FacesContext context, UIComponent component) {
            return component.getClientId(context) + ".lbl";
        }

        public String getStyleClass(FacesContext context, UIComponent component) {
            return "rf-pb-lbl";
        }

        public void encodeContent(FacesContext context, UIComponent component) throws IOException {
            Object label;
            ResponseWriter responseWriter = context.getResponseWriter();
            if (component.getChildCount() > 0) {
                for (UIComponent child : component.getChildren()) {
                    child.encodeAll(context);
                }
            }
            if ((label = component.getAttributes().get("label")) != null) {
                responseWriter.writeText(label, null);
            }
        }

        public boolean hasContent(FacesContext context, UIComponent component) {
            return true;
        }

        public void encodeStateForMetaComponent(FacesContext context, UIComponent component, ProgressBarStateEncoder encoder) throws IOException {
            encoder.encodeProgressStateContent(context, component, this);
        }
    }
    ,
    finishState{

        public String getStateClientId(FacesContext context, UIComponent component) {
            return component.getClientId(context) + ".fin";
        }

        public String getStyleClass(FacesContext context, UIComponent component) {
            return HtmlUtil.concatClasses("rf-pb-fin", component.getAttributes().get("finishClass"));
        }

        public void encodeContent(FacesContext context, UIComponent component) throws IOException {
            UIComponent facet = component.getFacet("finish");
            if (facet != null) {
                facet.encodeAll(context);
            }
        }

        public boolean hasContent(FacesContext context, UIComponent component) {
            UIComponent facet = component.getFacet("finish");
            return facet != null && facet.isRendered();
        }

        public void encodeStateForMetaComponent(FacesContext context, UIComponent component, ProgressBarStateEncoder encoder) throws IOException {
            encoder.encodeCompleteState(context, component, this);
        }
    };


    public abstract String getStateClientId(FacesContext var1, UIComponent var2);

    public abstract String getStyleClass(FacesContext var1, UIComponent var2);

    public abstract void encodeContent(FacesContext var1, UIComponent var2) throws IOException;

    public abstract boolean hasContent(FacesContext var1, UIComponent var2);

    public abstract void encodeStateForMetaComponent(FacesContext var1, UIComponent var2, ProgressBarStateEncoder var3) throws IOException;
}

