/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.waypoint;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.waypoint.Waypoint;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.renderkit.CoreRenderer;

public class WaypointRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        Waypoint waypoint = (Waypoint)component;
        String clientId = waypoint.getClientId(fc);
        String context = waypoint.getForContext();
        if (context != null) {
            UIComponent forComponent = component.findComponent(context);
            if (forComponent == null) {
                throw new FacesException("Cannot find component '" + context + "'.");
            }
            context = ComponentUtils.escapeJQueryId((String)forComponent.getClientId(fc));
        } else {
            context = waypoint.getForContextSelector();
        }
        String widget = waypoint.resolveWidgetVar();
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFacesExt.cw('Waypoint', '" + widget + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",target:'" + ComponentUtils.findTarget(fc, waypoint) + "'");
        if (context != null) {
            writer.write(",context:'" + context + "'");
        }
        if (waypoint.getOffset() != null) {
            writer.write(",offset:" + waypoint.getOffset());
        }
        writer.write(",continuous:" + waypoint.isContinuous());
        writer.write(",onlyOnScroll:" + waypoint.isOnlyOnScroll());
        writer.write(",triggerOnce:" + waypoint.isTriggerOnce());
        this.encodeClientBehaviors(fc, waypoint);
        writer.write("});");
        writer.write(widget + ".destroy().create();");
        writer.write("});");
        this.endScript(writer);
    }
}

