/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.inputnumber;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.extensions.component.inputnumber.InputNumber;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputNumberRenderer
extends InputRenderer {
    private static final Logger LOGGER = Logger.getLogger(InputNumberRenderer.class.getName());

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        InputNumber inputNumber = (InputNumber)component;
        Converter converter = inputNumber.getConverter();
        String submittedValueString = (String)submittedValue;
        if (converter != null) {
            Object doubleConverted = converter.getAsObject(context, (UIComponent)inputNumber, submittedValueString);
            return doubleConverted;
        }
        if (submittedValueString != null && !submittedValueString.isEmpty()) {
            return Double.valueOf(submittedValueString);
        }
        return null;
    }

    public void decode(FacesContext context, UIComponent component) {
        InputNumber inputNumber = (InputNumber)component;
        if (inputNumber.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputNumber);
        String inputId = inputNumber.getClientId(context) + "_hinput";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            inputNumber.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputNumber inputNumber = (InputNumber)component;
        this.encodeMarkup(context, inputNumber);
        this.encodeScript(context, inputNumber);
    }

    protected void encodeMarkup(FacesContext context, InputNumber inputNumber) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputNumber.getClientId(context);
        String styleClass = inputNumber.getStyleClass();
        styleClass = styleClass == null ? "ui-inputNum ui-widget" : "ui-inputNum ui-widget " + styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        this.encodeOutput(context, inputNumber, clientId);
        this.encodeInput(context, inputNumber, clientId);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, InputNumber inputNumber, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_hinput";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (inputNumber.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)inputNumber.getOnchange(), null);
        }
        writer.endElement("input");
    }

    protected void encodeOutput(FacesContext context, InputNumber inputNumber, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String defaultClass = "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
        defaultClass = !inputNumber.isValid() ? defaultClass + " ui-state-error" : defaultClass;
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        this.renderPassThruAttributes(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_ATTRS);
        if (inputNumber.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (inputNumber.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputNumber.getStyle(), "style");
        }
        writer.writeAttribute("class", (Object)defaultClass, "");
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, InputNumber inputNumber) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputNumber.getClientId(context);
        this.startScript(writer, clientId);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)inputNumber);
        if (valueToRender == null) {
            valueToRender = "";
        }
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('InputNumber','" + inputNumber.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",disabled:" + inputNumber.isDisabled());
        writer.write(",valueToRender:'" + this.formatForPlugin(valueToRender) + "'");
        String metaOptions = this.getOptions(inputNumber);
        if (!metaOptions.isEmpty()) {
            writer.write(",pluginOptions:" + metaOptions);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputNumber);
        writer.write("});});");
        this.endScript(writer);
    }

    private String getOptions(InputNumber inputNumber) {
        String decimalSeparator = inputNumber.getDecimalSeparator();
        String thousandSeparator = inputNumber.getThousandSeparator();
        String symbol = inputNumber.getSymbol();
        String symbolPosition = inputNumber.getSymbolPosition();
        String minValue = inputNumber.getMinValue();
        String maxValue = inputNumber.getMaxValue();
        String roundMethod = inputNumber.getRoundMethod();
        String decimalPlaces = inputNumber.getDecimalPlaces();
        String emptyValue = inputNumber.getEmptyValue();
        String options = "";
        options = options + (decimalSeparator.isEmpty() ? "" : "aDec: '" + decimalSeparator + "',");
        if (thousandSeparator != null) {
            options = options + (thousandSeparator.isEmpty() ? "aSep:''," : "aSep: '" + thousandSeparator + "',");
        }
        options = options + (symbol.isEmpty() ? "" : "aSign: '" + symbol + "',");
        options = options + (symbolPosition.isEmpty() ? "" : "pSign: '" + symbolPosition + "',");
        options = options + (minValue.isEmpty() ? "" : "vMin: '" + minValue + "',");
        options = options + (maxValue.isEmpty() ? "" : "vMax: '" + maxValue + "',");
        options = options + (roundMethod.isEmpty() ? "" : "mRound: '" + roundMethod + "',");
        options = options + (decimalPlaces.isEmpty() ? "" : "mDec: '" + decimalPlaces + "',");
        if ((options = options + "wEmpty: '" + emptyValue + "',").isEmpty()) {
            return "";
        }
        int lastInd = options.length() - 1;
        if (options.charAt(lastInd) == ',') {
            options = options.substring(0, lastInd);
        }
        return "{" + options + "}";
    }

    private String formatForPlugin(String valueToRender) {
        if (valueToRender == null || valueToRender.isEmpty()) {
            return "";
        }
        try {
            double doubleToRender = Double.parseDouble(valueToRender);
            DecimalFormat formatter = new DecimalFormat("#0.0#");
            ((NumberFormat)formatter).setRoundingMode(RoundingMode.FLOOR);
            ((NumberFormat)formatter).setMinimumFractionDigits(10);
            ((NumberFormat)formatter).setMaximumFractionDigits(10);
            ((NumberFormat)formatter).setMaximumIntegerDigits(20);
            String f = formatter.format(doubleToRender);
            f = f.replace(',', '.');
            return f;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + valueToRender + "] to a double value;", e);
        }
    }
}

