/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.head;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.head.Head;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadRenderer
extends org.primefaces.renderkit.HeadRenderer {
    private static final String FACET_FIRST = "first";
    private static final String FACET_MIDDLE = "middle";
    private static final String FACET_LAST = "last";
    private static final String PREFIX_PRIMEFACES = "primefaces-";
    private static final String THEME_DEFAULT = "aristo";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Head head = (Head)component;
        writer.startElement("head", component);
        ArrayList<UIComponent> styles = new ArrayList<UIComponent>();
        ArrayList<UIComponent> scripts = new ArrayList<UIComponent>();
        this.fillScriptsAndStyles(context, styles, scripts);
        this.encodeFacet(context, component, FACET_FIRST);
        this.encodeTheme(context);
        for (UIComponent style : styles) {
            style.encodeAll(context);
        }
        this.encodeFacet(context, component, FACET_MIDDLE);
        for (UIComponent script : scripts) {
            script.encodeAll(context);
        }
        this.encodeTitle(head, writer);
        this.encodeShortcutIcon(head, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.encodeFacet(context, component, FACET_LAST);
        writer.endElement("head");
    }

    private void encodeTheme(FacesContext context) throws IOException {
        String theme = null;
        String themeParamValue = context.getExternalContext().getInitParameter("primefaces.THEME");
        if (themeParamValue == null) {
            theme = THEME_DEFAULT;
        } else {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        }
        if (theme != null && !theme.equalsIgnoreCase("none")) {
            this.encodeTheme(context, PREFIX_PRIMEFACES + theme, "theme.css");
        }
    }

    private void encodeFacet(FacesContext context, UIComponent component, String name) throws IOException {
        UIComponent facet = component.getFacet(name);
        if (facet != null) {
            facet.encodeAll(context);
        }
    }

    private void encodeTitle(Head head, ResponseWriter writer) throws IOException {
        if (head.getTitle() != null) {
            writer.startElement("title", null);
            writer.write(head.getTitle());
            writer.endElement("title");
        }
    }

    private void encodeShortcutIcon(Head head, ResponseWriter writer) throws IOException {
        if (head.getShortcutIcon() != null) {
            writer.startElement("link", null);
            writer.writeAttribute("rel", (Object)"shortcut icon", null);
            writer.writeAttribute("href", (Object)head.getShortcutIcon(), null);
            writer.endElement("link");
        }
    }

    private void fillScriptsAndStyles(FacesContext context, List<UIComponent> styles, List<UIComponent> scripts) {
        UIViewRoot viewRoot = context.getViewRoot();
        List resources = viewRoot.getComponentResources(context, "head");
        for (UIComponent resource : resources) {
            if ("javax.faces.resource.Stylesheet".equals(resource.getRendererType())) {
                styles.add(resource);
                continue;
            }
            if (!"javax.faces.resource.Script".equals(resource.getRendererType())) continue;
            scripts.add(resource);
        }
    }
}

