/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.timeline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.primefaces.extensions.model.timeline.Timeline;
import org.primefaces.extensions.model.timeline.TimelineEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeLine
implements Timeline,
Serializable {
    private String id;
    private String title;
    private List<TimelineEvent> events;

    public DefaultTimeLine() {
        this.events = new ArrayList<TimelineEvent>();
    }

    public DefaultTimeLine(String id, String title) {
        this.id = id;
        this.title = title;
        this.events = new ArrayList<TimelineEvent>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void addEvent(TimelineEvent event) {
        event.setId(UUID.randomUUID().toString());
        this.events.add(event);
    }

    @Override
    public boolean deleteEvent(TimelineEvent event) {
        return this.events.remove(event);
    }

    @Override
    public List<TimelineEvent> getEvents() {
        return this.events;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultTimeLine)) {
            return false;
        }
        DefaultTimeLine that = (DefaultTimeLine)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.title;
    }
}

