/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.ckeditor;

import java.io.IOException;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.primefaces.extensions.component.ckeditor.CKEditor;
import org.primefaces.extensions.renderkit.widget.WidgetRenderer;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.renderkit.InputRenderer;

public class CKEditorRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        CKEditor ckEditor = (CKEditor)component;
        if (ckEditor.isReadOnly()) {
            return;
        }
        String clientId = ckEditor.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            ckEditor.setSubmittedValue(params.get(clientId));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CKEditor ckEditor = (CKEditor)component;
        this.encodeMarkup(context, ckEditor);
        this.encodeScript(context, ckEditor);
    }

    protected void encodeMarkup(FacesContext context, CKEditor ckEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ckEditor.getClientId(context);
        writer.startElement("textarea", (UIComponent)ckEditor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (ckEditor.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)ckEditor.getTabindex(), null);
        }
        if (ckEditor.getValue() != null) {
            if (ckEditor.isEscape()) {
                writer.writeText((Object)ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)ckEditor), null);
            } else {
                writer.write(ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)ckEditor));
            }
        }
        writer.endElement("textarea");
    }

    protected void encodeScript(FacesContext context, CKEditor ckEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ckEditor.getClientId(context);
        String widgetVar = ckEditor.resolveWidgetVar();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('" + CKEditor.class.getSimpleName() + "', '" + widgetVar + "', {");
        WidgetRenderer.renderOptions(clientId, writer, ckEditor);
        this.encodeClientBehaviors(context, ckEditor);
        writer.write("}, true);});");
        this.endScript(writer);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        CKEditor ckEditor = (CKEditor)component;
        String value = (String)submittedValue;
        Converter converter = ckEditor.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)ckEditor, value);
        }
        ValueExpression ve = ckEditor.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            Converter converterForType = context.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsObject(context, (UIComponent)ckEditor, value);
            }
        }
        return value;
    }
}

