/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import org.primefaces.extensions.application.PrimeFacesExtensionsResource;
import org.primefaces.extensions.application.PrimeFacesResource;
import org.primefaces.extensions.util.ContextParametersProvider;

public class PrimeFacesExtensionsResourceHandler
extends ResourceHandlerWrapper {
    public static final String[] UNCOMPRESSED_EXCLUDES = new String[]{"ckeditor/"};
    private final ResourceHandler wrapped;

    public PrimeFacesExtensionsResourceHandler(ResourceHandler resourceHandler) {
        this.wrapped = resourceHandler;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public Resource createResource(String resourceName, String libraryName) {
        Object resource = super.createResource(resourceName, libraryName);
        if (resource != null && libraryName != null) {
            if (ContextParametersProvider.getInstance().isWrapPrimeFacesResources() && libraryName.equalsIgnoreCase("primefaces")) {
                resource = new PrimeFacesResource((Resource)resource);
            } else if (libraryName.equalsIgnoreCase("primefaces-extensions")) {
                if (this.deliverUncompressedFile(resourceName)) {
                    resource = super.createResource(resourceName, "primefaces-extensions-uncompressed");
                }
                if (resource != null) {
                    resource = new PrimeFacesExtensionsResource((Resource)resource);
                }
            }
        }
        return resource;
    }

    protected boolean deliverUncompressedFile(String resourceName) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (ContextParametersProvider.getInstance().isDeliverUncompressedResources() && context.isProjectStage(ProjectStage.Development) && (resourceName.endsWith(".css") || resourceName.endsWith(".js"))) {
            for (String exclude : UNCOMPRESSED_EXCLUDES) {
                if (!resourceName.contains(exclude)) continue;
                return false;
            }
            return ContextParametersProvider.getInstance().isDeliverUncompressedResources();
        }
        return false;
    }
}

