/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.mockmaker;

import org.mockito.Mockito;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.InvocationContainer;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;
import org.powermock.api.mockito.invocation.MockitoMethodInvocationControl;
import org.powermock.api.mockito.mockmaker.MockMakerLoader;
import org.powermock.configuration.GlobalConfiguration;
import org.powermock.core.MockRepository;

public class PowerMockMaker
implements MockMaker {
    private final MockMaker mockMaker = new MockMakerLoader().load(GlobalConfiguration.mockitoConfiguration());

    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        return (T)this.mockMaker.createMock(settings, handler);
    }

    public MockHandler getHandler(Object mock) {
        if (mock instanceof Class) {
            return this.staticMockHandler((Class)mock);
        }
        return this.instanceMockHandler(mock);
    }

    private MockHandler instanceMockHandler(Object mock) {
        return this.mockMaker.getHandler(this.getRealMock(mock));
    }

    private Object getRealMock(Object mock) {
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl((Object)mock);
        Object realMock = invocationControl == null ? mock : invocationControl.getMockHandlerAdaptor().getMock();
        return realMock;
    }

    private MockHandler staticMockHandler(Class mock) {
        return new StaticMockHandler(this.createStaticMockSettings(mock));
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        this.mockMaker.resetMock(mock, newHandler, settings);
    }

    public MockMaker.TypeMockability isTypeMockable(Class<?> type) {
        return this.mockMaker.isTypeMockable(type);
    }

    MockMaker getMockMaker() {
        return this.mockMaker;
    }

    private MockCreationSettings<Class> createStaticMockSettings(Class mock) {
        return Mockito.withSettings().name(mock.getName()).build(mock);
    }

    private static class StaticMockHandler
    implements MockHandler<Class> {
        private final MockCreationSettings<Class> mockSettings;

        private StaticMockHandler(MockCreationSettings<Class> mockSettings) {
            this.mockSettings = mockSettings;
        }

        public MockCreationSettings<Class> getMockSettings() {
            return this.mockSettings;
        }

        public InvocationContainer getInvocationContainer() {
            return null;
        }

        public Object handle(Invocation invocation) throws Throwable {
            return null;
        }
    }
}

